<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCardDetails StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceGetCardDetails extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardSequenceNumber
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardSequenceNumber;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * Constructor method for getCardDetails
     * @uses CardServiceGetCardDetails::setProjectId()
     * @uses CardServiceGetCardDetails::setCardSequenceNumber()
     * @uses CardServiceGetCardDetails::setCardType()
     * @param string $projectId
     * @param string $cardSequenceNumber
     * @param string $cardType
     */
    public function __construct($projectId = null, $cardSequenceNumber = null, $cardType = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardSequenceNumber($cardSequenceNumber)
            ->setCardType($cardType);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \CardService\StructType\CardServiceGetCardDetails
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardSequenceNumber value
     * @return string|null
     */
    public function getCardSequenceNumber()
    {
        return $this->cardSequenceNumber;
    }
    /**
     * Set cardSequenceNumber value
     * @param string $cardSequenceNumber
     * @return \CardService\StructType\CardServiceGetCardDetails
     */
    public function setCardSequenceNumber($cardSequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardSequenceNumber) && !is_string($cardSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardSequenceNumber)), __LINE__);
        }
        $this->cardSequenceNumber = $cardSequenceNumber;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \CardService\StructType\CardServiceGetCardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceGetCardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
