<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addCommentToCardInput StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceAddCommentToCardInput extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardId;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $comment;
    /**
     * Constructor method for addCommentToCardInput
     * @uses CardServiceAddCommentToCardInput::setProjectId()
     * @uses CardServiceAddCommentToCardInput::setCardType()
     * @uses CardServiceAddCommentToCardInput::setCardId()
     * @uses CardServiceAddCommentToCardInput::setComment()
     * @param string $projectId
     * @param string $cardType
     * @param string $cardId
     * @param string $comment
     */
    public function __construct($projectId = null, $cardType = null, $cardId = null, $comment = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardId($cardId)
            ->setComment($comment);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \CardService\StructType\CardServiceAddCommentToCardInput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \CardService\StructType\CardServiceAddCommentToCardInput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->cardId;
    }
    /**
     * Set cardId value
     * @param string $cardId
     * @return \CardService\StructType\CardServiceAddCommentToCardInput
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardId)), __LINE__);
        }
        $this->cardId = $cardId;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \CardService\StructType\CardServiceAddCommentToCardInput
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceAddCommentToCardInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
