<?php

namespace CardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addCardResponse StructType
 * @package CardService
 * @subpackage Structs
 */
class CardServiceAddCardResponse extends AbstractStructBase
{
    /**
     * The ExternalCardId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $ExternalCardId;
    /**
     * The CardId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $CardId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $Status;
    /**
     * The StatusMsg
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StatusMsg;
    /**
     * Constructor method for addCardResponse
     * @uses CardServiceAddCardResponse::setExternalCardId()
     * @uses CardServiceAddCardResponse::setCardId()
     * @uses CardServiceAddCardResponse::setStatus()
     * @uses CardServiceAddCardResponse::setStatusMsg()
     * @param string $externalCardId
     * @param string $cardId
     * @param string $status
     * @param string $statusMsg
     */
    public function __construct($externalCardId = null, $cardId = null, $status = null, $statusMsg = null)
    {
        $this
            ->setExternalCardId($externalCardId)
            ->setCardId($cardId)
            ->setStatus($status)
            ->setStatusMsg($statusMsg);
    }
    /**
     * Get ExternalCardId value
     * @return string|null
     */
    public function getExternalCardId()
    {
        return $this->ExternalCardId;
    }
    /**
     * Set ExternalCardId value
     * @param string $externalCardId
     * @return \CardService\StructType\CardServiceAddCardResponse
     */
    public function setExternalCardId($externalCardId = null)
    {
        // validation for constraint: string
        if (!is_null($externalCardId) && !is_string($externalCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalCardId)), __LINE__);
        }
        $this->ExternalCardId = $externalCardId;
        return $this;
    }
    /**
     * Get CardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param string $cardId
     * @return \CardService\StructType\CardServiceAddCardResponse
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \CardService\StructType\CardServiceAddCardResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusMsg value
     * @return string|null
     */
    public function getStatusMsg()
    {
        return $this->StatusMsg;
    }
    /**
     * Set StatusMsg value
     * @param string $statusMsg
     * @return \CardService\StructType\CardServiceAddCardResponse
     */
    public function setStatusMsg($statusMsg = null)
    {
        // validation for constraint: string
        if (!is_null($statusMsg) && !is_string($statusMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMsg)), __LINE__);
        }
        $this->StatusMsg = $statusMsg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CardService\StructType\CardServiceAddCardResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
