<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceUpdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceUpdateCardDetails $part1
     * @return \CardService\StructType\CardServiceUpdateCardResponse|bool
     */
    public function updateCard(\CardService\StructType\CardServiceUpdateCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceUpdateCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
