<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unblock ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceUnblock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named unblockCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceUnblockCardDetails $part1
     * @return \CardService\StructType\CardServiceUnblockCardResponse|bool
     */
    public function unblockCard(\CardService\StructType\CardServiceUnblockCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->unblockCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceUnblockCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
