<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reply ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceReply extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named replyToComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceReplyToCommentInput $part1
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput|bool
     */
    public function replyToComment(\CardService\StructType\CardServiceReplyToCommentInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->replyToComment($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceAddCommentToCardOutput
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
