<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getProject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getProjectDetails $getProjectDetails
     * @return \CardService\StructType\CardServiceGetProjectResponse|bool
     */
    public function getProject($getProjectDetails)
    {
        try {
            $this->setResult(self::getSoapClient()->getProject($getProjectDetails));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceGetCardDetails $part1
     * @return \CardService\StructType\CardServiceGetCardResponse|bool
     */
    public function getCard(\CardService\StructType\CardServiceGetCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceGetCardResponse|\CardService\StructType\CardServiceGetProjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
