<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceDelete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceDeleteCardDetails $part1
     * @return \CardService\StructType\CardServiceDeleteCardResponse|bool
     */
    public function deleteCard(\CardService\StructType\CardServiceDeleteCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceDeleteCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
