<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Block ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceBlock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named blockCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceBlockCardDetails $part1
     * @return \CardService\StructType\CardServiceBlockCardResponse|bool
     */
    public function blockCard(\CardService\StructType\CardServiceBlockCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->blockCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceBlockCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
