<?php

namespace CardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Archive ServiceType
 * @package CardService
 * @subpackage Services
 */
class CardServiceArchive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named archiveCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CardService\StructType\CardServiceArchiveCardDetails $part1
     * @return \CardService\StructType\CardServiceArchiveCardResponse|bool
     */
    public function archiveCard(\CardService\StructType\CardServiceArchiveCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->archiveCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CardService\StructType\CardServiceArchiveCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
