<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetUpdate StructType
 * @subpackage Structs
 */
class TargetUpdate extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Value type used for specifying target parameters while updating already existing targets.
     * @var \StructType\TargetId
     */
    public $id;
    /**
     * The maxBid
     * Meta information extracted from the WSDL
     * - documentation: Value type used for specifying target parameters while updating already existing targets.
     * @var float
     */
    public $maxBid;
    /**
     * Constructor method for TargetUpdate
     * @uses TargetUpdate::setId()
     * @uses TargetUpdate::setMaxBid()
     * @param \StructType\TargetId $id
     * @param float $maxBid
     */
    public function __construct(\StructType\TargetId $id = null, $maxBid = null)
    {
        $this
            ->setId($id)
            ->setMaxBid($maxBid);
    }
    /**
     * Get id value
     * @return \StructType\TargetId|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\TargetId $id
     * @return \StructType\TargetUpdate
     */
    public function setId(\StructType\TargetId $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get maxBid value
     * @return float|null
     */
    public function getMaxBid()
    {
        return $this->maxBid;
    }
    /**
     * Set maxBid value
     * @param float $maxBid
     * @return \StructType\TargetUpdate
     */
    public function setMaxBid($maxBid = null)
    {
        // validation for constraint: float
        if (!is_null($maxBid) && !(is_float($maxBid) || is_numeric($maxBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxBid, true), gettype($maxBid)), __LINE__);
        }
        $this->maxBid = $maxBid;
        return $this;
    }
}
