<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetId StructType
 * @subpackage Structs
 */
class TargetId extends AbstractStructBase
{
    /**
     * The creativeId
     * Meta information extracted from the WSDL
     * - documentation: Value type representing the compound ID value of a target.
     * @var int
     */
    public $creativeId;
    /**
     * The targetId
     * Meta information extracted from the WSDL
     * - documentation: Value type representing the compound ID value of a target.
     * @var int
     */
    public $targetId;
    /**
     * Constructor method for TargetId
     * @uses TargetId::setCreativeId()
     * @uses TargetId::setTargetId()
     * @param int $creativeId
     * @param int $targetId
     */
    public function __construct($creativeId = null, $targetId = null)
    {
        $this
            ->setCreativeId($creativeId)
            ->setTargetId($targetId);
    }
    /**
     * Get creativeId value
     * @return int|null
     */
    public function getCreativeId()
    {
        return $this->creativeId;
    }
    /**
     * Set creativeId value
     * @param int $creativeId
     * @return \StructType\TargetId
     */
    public function setCreativeId($creativeId = null)
    {
        // validation for constraint: int
        if (!is_null($creativeId) && !(is_int($creativeId) || ctype_digit($creativeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creativeId, true), gettype($creativeId)), __LINE__);
        }
        $this->creativeId = $creativeId;
        return $this;
    }
    /**
     * Get targetId value
     * @return int|null
     */
    public function getTargetId()
    {
        return $this->targetId;
    }
    /**
     * Set targetId value
     * @param int $targetId
     * @return \StructType\TargetId
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: int
        if (!is_null($targetId) && !(is_int($targetId) || ctype_digit($targetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        $this->targetId = $targetId;
        return $this;
    }
}
