<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://apitest.trafficvance.com/?v3=targets.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://apitest.trafficvance.com/?v3=targets.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthenticateRequest(new \StructType\AuthenticateRequest());
/**
 * Sample call for getTargetIds operation/method
 */
if ($get->getTargetIds(new \StructType\GetTargetIdsParameters()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTargets operation/method
 */
if ($get->getTargets(new \StructType\GetTargetsParameters()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCategories operation/method
 */
if ($get->getCategories() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSuggested operation/method
 */
if ($get->getSuggested(new \StructType\GetSuggestedParameters()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderAuthenticateRequest(new \StructType\AuthenticateRequest());
/**
 * Sample call for addTargets operation/method
 */
if ($add->addTargets(new \StructType\AddTargetsParameters()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderAuthenticateRequest(new \StructType\AuthenticateRequest());
/**
 * Sample call for updateTargets operation/method
 */
if ($update->updateTargets(new \StructType\UpdateTargetsParameters()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Resume ServiceType
 */
$resume = new \ServiceType\Resume($options);
$resume->setSoapHeaderAuthenticateRequest(new \StructType\AuthenticateRequest());
/**
 * Sample call for resumeTargets operation/method
 */
if ($resume->resumeTargets(new \StructType\ResumeTargetsParameters()) !== false) {
    print_r($resume->getResult());
} else {
    print_r($resume->getLastError());
}
/**
 * Samples for Pause ServiceType
 */
$pause = new \ServiceType\Pause($options);
$pause->setSoapHeaderAuthenticateRequest(new \StructType\AuthenticateRequest());
/**
 * Sample call for pauseTargets operation/method
 */
if ($pause->pauseTargets(new \StructType\PauseTargetsParameters()) !== false) {
    print_r($pause->getResult());
} else {
    print_r($pause->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderAuthenticateRequest(new \StructType\AuthenticateRequest());
/**
 * Sample call for deleteTargets operation/method
 */
if ($delete->deleteTargets(new \StructType\DeleteTargetsParameters()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
