<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetUpdated StructType
 * @subpackage Structs
 */
class TargetUpdated extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Return value type used for the targets having their max. bids updated while updating your already existing targets.
     * @var \StructType\TargetId
     */
    public $id;
    /**
     * The maxBid
     * Meta information extracted from the WSDL
     * - documentation: Return value type used for the targets having their max. bids updated while updating your already existing targets.
     * @var float
     */
    public $maxBid;
    /**
     * Constructor method for TargetUpdated
     * @uses TargetUpdated::setId()
     * @uses TargetUpdated::setMaxBid()
     * @param \StructType\TargetId $id
     * @param float $maxBid
     */
    public function __construct(\StructType\TargetId $id = null, $maxBid = null)
    {
        $this
            ->setId($id)
            ->setMaxBid($maxBid);
    }
    /**
     * Get id value
     * @return \StructType\TargetId|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\TargetId $id
     * @return \StructType\TargetUpdated
     */
    public function setId(\StructType\TargetId $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get maxBid value
     * @return float|null
     */
    public function getMaxBid()
    {
        return $this->maxBid;
    }
    /**
     * Set maxBid value
     * @param float $maxBid
     * @return \StructType\TargetUpdated
     */
    public function setMaxBid($maxBid = null)
    {
        // validation for constraint: float
        if (!is_null($maxBid) && !(is_float($maxBid) || is_numeric($maxBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxBid, true), gettype($maxBid)), __LINE__);
        }
        $this->maxBid = $maxBid;
        return $this;
    }
}
