<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetStats StructType
 * @subpackage Structs
 */
class TargetStats extends AbstractStructBase
{
    /**
     * The activity
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching activity, ranks and brief stats data for your already existing target.<br /><br /> Please note that at most one of the properties&nbsp; <span class="showcode">averageRank</span>&nbsp; and&nbsp;
     * <span class="showcode">estimatedRank</span>&nbsp; can be received as a non&ndash;<b>Null</b> value, meaning that values for <b>average rank</b> and <b>rank estimate</b> are never available both at the same time.&nbsp; However, they can be both
     * received as <b>Null</b> in case the target has not had any clicks or impressions recently.
     * @var int
     */
    public $activity;
    /**
     * The openingBid
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching activity, ranks and brief stats data for your already existing target.<br /><br /> Please note that at most one of the properties&nbsp; <span class="showcode">averageRank</span>&nbsp; and&nbsp;
     * <span class="showcode">estimatedRank</span>&nbsp; can be received as a non&ndash;<b>Null</b> value, meaning that values for <b>average rank</b> and <b>rank estimate</b> are never available both at the same time.&nbsp; However, they can be both
     * received as <b>Null</b> in case the target has not had any clicks or impressions recently.
     * - nillable: true
     * @var float
     */
    public $openingBid;
    /**
     * The averageRank
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching activity, ranks and brief stats data for your already existing target.<br /><br /> Please note that at most one of the properties&nbsp; <span class="showcode">averageRank</span>&nbsp; and&nbsp;
     * <span class="showcode">estimatedRank</span>&nbsp; can be received as a non&ndash;<b>Null</b> value, meaning that values for <b>average rank</b> and <b>rank estimate</b> are never available both at the same time.&nbsp; However, they can be both
     * received as <b>Null</b> in case the target has not had any clicks or impressions recently.
     * - nillable: true
     * @var float
     */
    public $averageRank;
    /**
     * The estimatedRank
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching activity, ranks and brief stats data for your already existing target.<br /><br /> Please note that at most one of the properties&nbsp; <span class="showcode">averageRank</span>&nbsp; and&nbsp;
     * <span class="showcode">estimatedRank</span>&nbsp; can be received as a non&ndash;<b>Null</b> value, meaning that values for <b>average rank</b> and <b>rank estimate</b> are never available both at the same time.&nbsp; However, they can be both
     * received as <b>Null</b> in case the target has not had any clicks or impressions recently.
     * - nillable: true
     * @var string
     */
    public $estimatedRank;
    /**
     * The lastServed
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching activity, ranks and brief stats data for your already existing target.<br /><br /> Please note that at most one of the properties&nbsp; <span class="showcode">averageRank</span>&nbsp; and&nbsp;
     * <span class="showcode">estimatedRank</span>&nbsp; can be received as a non&ndash;<b>Null</b> value, meaning that values for <b>average rank</b> and <b>rank estimate</b> are never available both at the same time.&nbsp; However, they can be both
     * received as <b>Null</b> in case the target has not had any clicks or impressions recently.
     * - nillable: true
     * @var string
     */
    public $lastServed;
    /**
     * Constructor method for TargetStats
     * @uses TargetStats::setActivity()
     * @uses TargetStats::setOpeningBid()
     * @uses TargetStats::setAverageRank()
     * @uses TargetStats::setEstimatedRank()
     * @uses TargetStats::setLastServed()
     * @param int $activity
     * @param float $openingBid
     * @param float $averageRank
     * @param string $estimatedRank
     * @param string $lastServed
     */
    public function __construct($activity = null, $openingBid = null, $averageRank = null, $estimatedRank = null, $lastServed = null)
    {
        $this
            ->setActivity($activity)
            ->setOpeningBid($openingBid)
            ->setAverageRank($averageRank)
            ->setEstimatedRank($estimatedRank)
            ->setLastServed($lastServed);
    }
    /**
     * Get activity value
     * @return int|null
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @param int $activity
     * @return \StructType\TargetStats
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: int
        if (!is_null($activity) && !(is_int($activity) || ctype_digit($activity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activity, true), gettype($activity)), __LINE__);
        }
        $this->activity = $activity;
        return $this;
    }
    /**
     * Get openingBid value
     * @return float|null
     */
    public function getOpeningBid()
    {
        return $this->openingBid;
    }
    /**
     * Set openingBid value
     * @param float $openingBid
     * @return \StructType\TargetStats
     */
    public function setOpeningBid($openingBid = null)
    {
        // validation for constraint: float
        if (!is_null($openingBid) && !(is_float($openingBid) || is_numeric($openingBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($openingBid, true), gettype($openingBid)), __LINE__);
        }
        $this->openingBid = $openingBid;
        return $this;
    }
    /**
     * Get averageRank value
     * @return float|null
     */
    public function getAverageRank()
    {
        return $this->averageRank;
    }
    /**
     * Set averageRank value
     * @param float $averageRank
     * @return \StructType\TargetStats
     */
    public function setAverageRank($averageRank = null)
    {
        // validation for constraint: float
        if (!is_null($averageRank) && !(is_float($averageRank) || is_numeric($averageRank))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageRank, true), gettype($averageRank)), __LINE__);
        }
        $this->averageRank = $averageRank;
        return $this;
    }
    /**
     * Get estimatedRank value
     * @return string|null
     */
    public function getEstimatedRank()
    {
        return $this->estimatedRank;
    }
    /**
     * Set estimatedRank value
     * @uses \EnumType\TargetEstimatedRank::valueIsValid()
     * @uses \EnumType\TargetEstimatedRank::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estimatedRank
     * @return \StructType\TargetStats
     */
    public function setEstimatedRank($estimatedRank = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TargetEstimatedRank::valueIsValid($estimatedRank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TargetEstimatedRank', is_array($estimatedRank) ? implode(', ', $estimatedRank) : var_export($estimatedRank, true), implode(', ', \EnumType\TargetEstimatedRank::getValidValues())), __LINE__);
        }
        $this->estimatedRank = $estimatedRank;
        return $this;
    }
    /**
     * Get lastServed value
     * @return string|null
     */
    public function getLastServed()
    {
        return $this->lastServed;
    }
    /**
     * Set lastServed value
     * @param string $lastServed
     * @return \StructType\TargetStats
     */
    public function setLastServed($lastServed = null)
    {
        // validation for constraint: string
        if (!is_null($lastServed) && !is_string($lastServed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastServed, true), gettype($lastServed)), __LINE__);
        }
        $this->lastServed = $lastServed;
        return $this;
    }
}
