<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetAdded StructType
 * @subpackage Structs
 */
class TargetAdded extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Return value type used for the targets added while adding new targets into your creative.
     * @var \StructType\TargetId
     */
    public $id;
    /**
     * The target
     * Meta information extracted from the WSDL
     * - documentation: Return value type used for the targets added while adding new targets into your creative.
     * @var string
     */
    public $target;
    /**
     * The maxBid
     * Meta information extracted from the WSDL
     * - documentation: Return value type used for the targets added while adding new targets into your creative.
     * @var float
     */
    public $maxBid;
    /**
     * Constructor method for TargetAdded
     * @uses TargetAdded::setId()
     * @uses TargetAdded::setTarget()
     * @uses TargetAdded::setMaxBid()
     * @param \StructType\TargetId $id
     * @param string $target
     * @param float $maxBid
     */
    public function __construct(\StructType\TargetId $id = null, $target = null, $maxBid = null)
    {
        $this
            ->setId($id)
            ->setTarget($target)
            ->setMaxBid($maxBid);
    }
    /**
     * Get id value
     * @return \StructType\TargetId|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\TargetId $id
     * @return \StructType\TargetAdded
     */
    public function setId(\StructType\TargetId $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\TargetAdded
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get maxBid value
     * @return float|null
     */
    public function getMaxBid()
    {
        return $this->maxBid;
    }
    /**
     * Set maxBid value
     * @param float $maxBid
     * @return \StructType\TargetAdded
     */
    public function setMaxBid($maxBid = null)
    {
        // validation for constraint: float
        if (!is_null($maxBid) && !(is_float($maxBid) || is_numeric($maxBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxBid, true), gettype($maxBid)), __LINE__);
        }
        $this->maxBid = $maxBid;
        return $this;
    }
}
