<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getTargetsParameters StructType
 * @subpackage Structs
 */
class GetTargetsParameters extends AbstractStructBase
{
    /**
     * The targetIds
     * Meta information extracted from the WSDL
     * - documentation: List of targets compound ID values
     * @var \ArrayType\Array_TargetId_1_1000
     */
    public $targetIds;
    /**
     * The fetchStats
     * Meta information extracted from the WSDL
     * - documentation: Option for also fetching activity, ranks and brief stats data for the returned targets
     * - nillable: true
     * @var bool
     */
    public $fetchStats;
    /**
     * Constructor method for getTargetsParameters
     * @uses GetTargetsParameters::setTargetIds()
     * @uses GetTargetsParameters::setFetchStats()
     * @param \ArrayType\Array_TargetId_1_1000 $targetIds
     * @param bool $fetchStats
     */
    public function __construct(\ArrayType\Array_TargetId_1_1000 $targetIds = null, $fetchStats = null)
    {
        $this
            ->setTargetIds($targetIds)
            ->setFetchStats($fetchStats);
    }
    /**
     * Get targetIds value
     * @return \ArrayType\Array_TargetId_1_1000|null
     */
    public function getTargetIds()
    {
        return $this->targetIds;
    }
    /**
     * Set targetIds value
     * @param \ArrayType\Array_TargetId_1_1000 $targetIds
     * @return \StructType\GetTargetsParameters
     */
    public function setTargetIds(\ArrayType\Array_TargetId_1_1000 $targetIds = null)
    {
        $this->targetIds = $targetIds;
        return $this;
    }
    /**
     * Get fetchStats value
     * @return bool|null
     */
    public function getFetchStats()
    {
        return $this->fetchStats;
    }
    /**
     * Set fetchStats value
     * @param bool $fetchStats
     * @return \StructType\GetTargetsParameters
     */
    public function setFetchStats($fetchStats = null)
    {
        // validation for constraint: boolean
        if (!is_null($fetchStats) && !is_bool($fetchStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fetchStats, true), gettype($fetchStats)), __LINE__);
        }
        $this->fetchStats = $fetchStats;
        return $this;
    }
}
