<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addTargetsParameters StructType
 * @subpackage Structs
 */
class AddTargetsParameters extends AbstractStructBase
{
    /**
     * The creativeId
     * Meta information extracted from the WSDL
     * - documentation: Creative ID value for the destination creative
     * @var int
     */
    public $creativeId;
    /**
     * The targets
     * Meta information extracted from the WSDL
     * - documentation: Targets definition data
     * @var \ArrayType\Array_TargetAdd_1_1000
     */
    public $targets;
    /**
     * Constructor method for addTargetsParameters
     * @uses AddTargetsParameters::setCreativeId()
     * @uses AddTargetsParameters::setTargets()
     * @param int $creativeId
     * @param \ArrayType\Array_TargetAdd_1_1000 $targets
     */
    public function __construct($creativeId = null, \ArrayType\Array_TargetAdd_1_1000 $targets = null)
    {
        $this
            ->setCreativeId($creativeId)
            ->setTargets($targets);
    }
    /**
     * Get creativeId value
     * @return int|null
     */
    public function getCreativeId()
    {
        return $this->creativeId;
    }
    /**
     * Set creativeId value
     * @param int $creativeId
     * @return \StructType\AddTargetsParameters
     */
    public function setCreativeId($creativeId = null)
    {
        // validation for constraint: int
        if (!is_null($creativeId) && !(is_int($creativeId) || ctype_digit($creativeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creativeId, true), gettype($creativeId)), __LINE__);
        }
        $this->creativeId = $creativeId;
        return $this;
    }
    /**
     * Get targets value
     * @return \ArrayType\Array_TargetAdd_1_1000|null
     */
    public function getTargets()
    {
        return $this->targets;
    }
    /**
     * Set targets value
     * @param \ArrayType\Array_TargetAdd_1_1000 $targets
     * @return \StructType\AddTargetsParameters
     */
    public function setTargets(\ArrayType\Array_TargetAdd_1_1000 $targets = null)
    {
        $this->targets = $targets;
        return $this;
    }
}
