<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticateRequest SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticateRequest $authenticateRequest
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticateRequest(\StructType\AuthenticateRequest $authenticateRequest, $nameSpace = 'https://apitest.trafficvance.com/?v3=targets', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticateRequest', $authenticateRequest, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named deleteTargets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Deletes already existing targets from your account.&nbsp; Please note that once deleted, targets <b>can not</b> be accessed any longer or undeleted later. | Deletes already existing targets from your account.&nbsp; Please note that
     * once deleted, targets <b>can not</b> be accessed any longer or undeleted later.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteTargetsParameters $parameters
     * @return \StructType\TargetsDeleteResult|bool
     */
    public function deleteTargets(\StructType\DeleteTargetsParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteTargets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TargetsDeleteResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
