<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticateRequest SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticateRequest $authenticateRequest
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticateRequest(\StructType\AuthenticateRequest $authenticateRequest, $nameSpace = 'https://apitest.trafficvance.com/?v3=targets', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticateRequest', $authenticateRequest, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named addTargets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Adds new targets into your already existing creative.&nbsp; Please note that stored targets and max. bids can be <b>different</b> than the specified values, due to transformations performed before adding targets and bids rounding or
     * your minimal and maximal allowed bids; see types&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=Target">Target</a></span> ,&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=TargetAdd">TargetAdd</a></span>&nbsp;
     * and&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=TargetAdded">TargetAdded</a></span>&nbsp; and/or operation&nbsp; <span class="showcode"><a href="{SystemService}#getRegions">getRegions()</a></span>&nbsp; for more details. | Adds
     * new targets into your already existing creative.&nbsp; Please note that stored targets and max. bids can be <b>different</b> than the specified values, due to transformations performed before adding targets and bids rounding or your minimal and
     * maximal allowed bids; see types&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=Target">Target</a></span> ,&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=TargetAdd">TargetAdd</a></span>&nbsp; and&nbsp; <span
     * class="showcode"><a href="/?docs=v3.Index&className=TargetAdded">TargetAdded</a></span>&nbsp; and/or operation&nbsp; <span class="showcode"><a href="{SystemService}#getRegions">getRegions()</a></span>&nbsp; for more details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTargetsParameters $parameters
     * @return \StructType\TargetsAddResult|bool
     */
    public function addTargets(\StructType\AddTargetsParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addTargets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TargetsAddResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
