<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TargetStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Available targets statuses
 * @subpackage Enumerations
 */
class TargetStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ACTIVE'
     * @return string 'ACTIVE'
     */
    const VALUE_ACTIVE = 'ACTIVE';
    /**
     * Constant for value 'PAUSED'
     * @return string 'PAUSED'
     */
    const VALUE_PAUSED = 'PAUSED';
    /**
     * Constant for value 'AWAITING APPROVAL'
     * @return string 'AWAITING APPROVAL'
     */
    const VALUE_AWAITING_APPROVAL = 'AWAITING APPROVAL';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Constant for value 'COMPLETED'
     * @return string 'COMPLETED'
     */
    const VALUE_COMPLETED = 'COMPLETED';
    /**
     * Constant for value 'NO FUNDS'
     * @return string 'NO FUNDS'
     */
    const VALUE_NO_FUNDS = 'NO FUNDS';
    /**
     * Constant for value 'DELETED'
     * @return string 'DELETED'
     */
    const VALUE_DELETED = 'DELETED';
    /**
     * Constant for value 'ARCHIVED'
     * @return string 'ARCHIVED'
     */
    const VALUE_ARCHIVED = 'ARCHIVED';
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_PAUSED
     * @uses self::VALUE_AWAITING_APPROVAL
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_NO_FUNDS
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_ARCHIVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_PAUSED,
            self::VALUE_AWAITING_APPROVAL,
            self::VALUE_REJECTED,
            self::VALUE_COMPLETED,
            self::VALUE_NO_FUNDS,
            self::VALUE_DELETED,
            self::VALUE_ARCHIVED,
        );
    }
}
