<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetSuggested StructType
 * @subpackage Structs
 */
class TargetSuggested extends AbstractStructBase
{
    /**
     * The target
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching suggested target that can be used within your creatives.
     * @var string
     */
    public $target;
    /**
     * The activity
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching suggested target that can be used within your creatives.
     * @var int
     */
    public $activity;
    /**
     * The openingBid
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching suggested target that can be used within your creatives.
     * - nillable: true
     * @var float
     */
    public $openingBid;
    /**
     * Constructor method for TargetSuggested
     * @uses TargetSuggested::setTarget()
     * @uses TargetSuggested::setActivity()
     * @uses TargetSuggested::setOpeningBid()
     * @param string $target
     * @param int $activity
     * @param float $openingBid
     */
    public function __construct($target = null, $activity = null, $openingBid = null)
    {
        $this
            ->setTarget($target)
            ->setActivity($activity)
            ->setOpeningBid($openingBid);
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\TargetSuggested
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get activity value
     * @return int|null
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @param int $activity
     * @return \StructType\TargetSuggested
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: int
        if (!is_null($activity) && !(is_int($activity) || ctype_digit($activity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activity, true), gettype($activity)), __LINE__);
        }
        $this->activity = $activity;
        return $this;
    }
    /**
     * Get openingBid value
     * @return float|null
     */
    public function getOpeningBid()
    {
        return $this->openingBid;
    }
    /**
     * Set openingBid value
     * @param float $openingBid
     * @return \StructType\TargetSuggested
     */
    public function setOpeningBid($openingBid = null)
    {
        // validation for constraint: float
        if (!is_null($openingBid) && !(is_float($openingBid) || is_numeric($openingBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($openingBid, true), gettype($openingBid)), __LINE__);
        }
        $this->openingBid = $openingBid;
        return $this;
    }
}
