<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetIgnored StructType
 * @subpackage Structs
 */
class TargetIgnored extends AbstractStructBase
{
    /**
     * The target
     * Meta information extracted from the WSDL
     * - documentation: Return value type used for the targets ignored while adding new targets into your creative.
     * @var string
     */
    public $target;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Return value type used for the targets ignored while adding new targets into your creative.
     * @var string
     */
    public $description;
    /**
     * Constructor method for TargetIgnored
     * @uses TargetIgnored::setTarget()
     * @uses TargetIgnored::setDescription()
     * @param string $target
     * @param string $description
     */
    public function __construct($target = null, $description = null)
    {
        $this
            ->setTarget($target)
            ->setDescription($description);
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\TargetIgnored
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TargetIgnored
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
