<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Target StructType
 * @subpackage Structs
 */
class Target extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var \StructType\TargetId
     */
    public $id;
    /**
     * The target
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var string
     */
    public $target;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var string
     */
    public $status;
    /**
     * The creativeType
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var string
     */
    public $creativeType;
    /**
     * The regionCode
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var string
     */
    public $regionCode;
    /**
     * The maxBid
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var float
     */
    public $maxBid;
    /**
     * The created
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var string
     */
    public $created;
    /**
     * The modified
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * @var string
     */
    public $modified;
    /**
     * The stats
     * Meta information extracted from the WSDL
     * - documentation: Return value type used while fetching stored data for your already existing target.
     * - nillable: true
     * @var \StructType\TargetStats
     */
    public $stats;
    /**
     * Constructor method for Target
     * @uses Target::setId()
     * @uses Target::setTarget()
     * @uses Target::setStatus()
     * @uses Target::setCreativeType()
     * @uses Target::setRegionCode()
     * @uses Target::setMaxBid()
     * @uses Target::setCreated()
     * @uses Target::setModified()
     * @uses Target::setStats()
     * @param \StructType\TargetId $id
     * @param string $target
     * @param string $status
     * @param string $creativeType
     * @param string $regionCode
     * @param float $maxBid
     * @param string $created
     * @param string $modified
     * @param \StructType\TargetStats $stats
     */
    public function __construct(\StructType\TargetId $id = null, $target = null, $status = null, $creativeType = null, $regionCode = null, $maxBid = null, $created = null, $modified = null, \StructType\TargetStats $stats = null)
    {
        $this
            ->setId($id)
            ->setTarget($target)
            ->setStatus($status)
            ->setCreativeType($creativeType)
            ->setRegionCode($regionCode)
            ->setMaxBid($maxBid)
            ->setCreated($created)
            ->setModified($modified)
            ->setStats($stats);
    }
    /**
     * Get id value
     * @return \StructType\TargetId|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\TargetId $id
     * @return \StructType\Target
     */
    public function setId(\StructType\TargetId $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\Target
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\TargetStatus::valueIsValid()
     * @uses \EnumType\TargetStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Target
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TargetStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TargetStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\TargetStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get creativeType value
     * @return string|null
     */
    public function getCreativeType()
    {
        return $this->creativeType;
    }
    /**
     * Set creativeType value
     * @uses \EnumType\CreativeType::valueIsValid()
     * @uses \EnumType\CreativeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creativeType
     * @return \StructType\Target
     */
    public function setCreativeType($creativeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreativeType::valueIsValid($creativeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreativeType', is_array($creativeType) ? implode(', ', $creativeType) : var_export($creativeType, true), implode(', ', \EnumType\CreativeType::getValidValues())), __LINE__);
        }
        $this->creativeType = $creativeType;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\Target
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get maxBid value
     * @return float|null
     */
    public function getMaxBid()
    {
        return $this->maxBid;
    }
    /**
     * Set maxBid value
     * @param float $maxBid
     * @return \StructType\Target
     */
    public function setMaxBid($maxBid = null)
    {
        // validation for constraint: float
        if (!is_null($maxBid) && !(is_float($maxBid) || is_numeric($maxBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxBid, true), gettype($maxBid)), __LINE__);
        }
        $this->maxBid = $maxBid;
        return $this;
    }
    /**
     * Get created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->created;
    }
    /**
     * Set created value
     * @param string $created
     * @return \StructType\Target
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->created = $created;
        return $this;
    }
    /**
     * Get modified value
     * @return string|null
     */
    public function getModified()
    {
        return $this->modified;
    }
    /**
     * Set modified value
     * @param string $modified
     * @return \StructType\Target
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modified, true), gettype($modified)), __LINE__);
        }
        $this->modified = $modified;
        return $this;
    }
    /**
     * Get stats value
     * @return \StructType\TargetStats|null
     */
    public function getStats()
    {
        return $this->stats;
    }
    /**
     * Set stats value
     * @param \StructType\TargetStats $stats
     * @return \StructType\Target
     */
    public function setStats(\StructType\TargetStats $stats = null)
    {
        $this->stats = $stats;
        return $this;
    }
}
