<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getTargetIdsParameters StructType
 * @subpackage Structs
 */
class GetTargetIdsParameters extends AbstractStructBase
{
    /**
     * The campaignIds
     * Meta information extracted from the WSDL
     * - documentation: Optional filter specification for campaign ID values
     * - nillable: true
     * @var \ArrayType\Array_unsignedInt_1_50
     */
    public $campaignIds;
    /**
     * The creativeIds
     * Meta information extracted from the WSDL
     * - documentation: Optional filter specification for creative ID values
     * - nillable: true
     * @var \ArrayType\Array_unsignedInt_1_100
     */
    public $creativeIds;
    /**
     * The filterNames
     * Meta information extracted from the WSDL
     * - documentation: Optional filter specification for targets (keywords or URLs)<br /><b>UTF-8</b> encoding is required, while all characters from <b>CP-1252</b> are supported
     * - nillable: true
     * @var \ArrayType\Array_string_1_100
     */
    public $filterNames;
    /**
     * Constructor method for getTargetIdsParameters
     * @uses GetTargetIdsParameters::setCampaignIds()
     * @uses GetTargetIdsParameters::setCreativeIds()
     * @uses GetTargetIdsParameters::setFilterNames()
     * @param \ArrayType\Array_unsignedInt_1_50 $campaignIds
     * @param \ArrayType\Array_unsignedInt_1_100 $creativeIds
     * @param \ArrayType\Array_string_1_100 $filterNames
     */
    public function __construct(\ArrayType\Array_unsignedInt_1_50 $campaignIds = null, \ArrayType\Array_unsignedInt_1_100 $creativeIds = null, \ArrayType\Array_string_1_100 $filterNames = null)
    {
        $this
            ->setCampaignIds($campaignIds)
            ->setCreativeIds($creativeIds)
            ->setFilterNames($filterNames);
    }
    /**
     * Get campaignIds value
     * @return \ArrayType\Array_unsignedInt_1_50|null
     */
    public function getCampaignIds()
    {
        return $this->campaignIds;
    }
    /**
     * Set campaignIds value
     * @param \ArrayType\Array_unsignedInt_1_50 $campaignIds
     * @return \StructType\GetTargetIdsParameters
     */
    public function setCampaignIds(\ArrayType\Array_unsignedInt_1_50 $campaignIds = null)
    {
        $this->campaignIds = $campaignIds;
        return $this;
    }
    /**
     * Get creativeIds value
     * @return \ArrayType\Array_unsignedInt_1_100|null
     */
    public function getCreativeIds()
    {
        return $this->creativeIds;
    }
    /**
     * Set creativeIds value
     * @param \ArrayType\Array_unsignedInt_1_100 $creativeIds
     * @return \StructType\GetTargetIdsParameters
     */
    public function setCreativeIds(\ArrayType\Array_unsignedInt_1_100 $creativeIds = null)
    {
        $this->creativeIds = $creativeIds;
        return $this;
    }
    /**
     * Get filterNames value
     * @return \ArrayType\Array_string_1_100|null
     */
    public function getFilterNames()
    {
        return $this->filterNames;
    }
    /**
     * Set filterNames value
     * @param \ArrayType\Array_string_1_100 $filterNames
     * @return \StructType\GetTargetIdsParameters
     */
    public function setFilterNames(\ArrayType\Array_string_1_100 $filterNames = null)
    {
        $this->filterNames = $filterNames;
        return $this;
    }
}
