<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSuggestedParameters StructType
 * @subpackage Structs
 */
class GetSuggestedParameters extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - documentation: Search pattern for targets suggestion &mdash; asterisk (*) can be used as a wildcard character<br /><b>UTF-8</b> encoding is required, while all characters from <b>CP-1252</b> are supported
     * @var string
     */
    public $pattern;
    /**
     * The regionCode
     * Meta information extracted from the WSDL
     * - documentation: Targeted region code; please see operation&nbsp; <span class="showcode"><a href="{SystemService}#getRegions">getRegions()</a></span>&nbsp; for more details
     * @var string
     */
    public $regionCode;
    /**
     * The creativeType
     * Meta information extracted from the WSDL
     * - documentation: Creative type; please note that suggestions are different for each type
     * @var string
     */
    public $creativeType;
    /**
     * Constructor method for getSuggestedParameters
     * @uses GetSuggestedParameters::setPattern()
     * @uses GetSuggestedParameters::setRegionCode()
     * @uses GetSuggestedParameters::setCreativeType()
     * @param string $pattern
     * @param string $regionCode
     * @param string $creativeType
     */
    public function __construct($pattern = null, $regionCode = null, $creativeType = null)
    {
        $this
            ->setPattern($pattern)
            ->setRegionCode($regionCode)
            ->setCreativeType($creativeType);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\GetSuggestedParameters
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\GetSuggestedParameters
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get creativeType value
     * @return string|null
     */
    public function getCreativeType()
    {
        return $this->creativeType;
    }
    /**
     * Set creativeType value
     * @uses \EnumType\CreativeType::valueIsValid()
     * @uses \EnumType\CreativeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creativeType
     * @return \StructType\GetSuggestedParameters
     */
    public function setCreativeType($creativeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreativeType::valueIsValid($creativeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreativeType', is_array($creativeType) ? implode(', ', $creativeType) : var_export($creativeType, true), implode(', ', \EnumType\CreativeType::getValidValues())), __LINE__);
        }
        $this->creativeType = $creativeType;
        return $this;
    }
}
