<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateRequest StructType
 * @subpackage Structs
 */
class AuthenticateRequest extends AbstractStructBase
{
    /**
     * The apiKey
     * @var string
     */
    public $apiKey;
    /**
     * Constructor method for AuthenticateRequest
     * @uses AuthenticateRequest::setApiKey()
     * @param string $apiKey
     */
    public function __construct($apiKey = null)
    {
        $this
            ->setApiKey($apiKey);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \StructType\AuthenticateRequest
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
}
