<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resume ServiceType
 * @subpackage Services
 */
class Resume extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticateRequest SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticateRequest $authenticateRequest
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticateRequest(\StructType\AuthenticateRequest $authenticateRequest, $nameSpace = 'https://apitest.trafficvance.com/?v3=targets', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticateRequest', $authenticateRequest, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named resumeTargets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Resumes your already existing and currently paused or rejected targets. | Resumes your already existing and currently paused or rejected targets.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResumeTargetsParameters $parameters
     * @return \StructType\TargetsStatusResult|bool
     */
    public function resumeTargets(\StructType\ResumeTargetsParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->resumeTargets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TargetsStatusResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
