<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetAdd StructType
 * @subpackage Structs
 */
class TargetAdd extends AbstractStructBase
{
    /**
     * The target
     * Meta information extracted from the WSDL
     * - documentation: Value type used for specifying target definition data while adding new targets into your creatives.<br /> Please note that <b>targeted region</b> is inherited by the targets from the creative into which new targets are actually
     * added.<br /><br /> UTF-8 <b>characters allowed</b> within targets are including the following:&nbsp; <span class="showcode">0&ndash;9 a&ndash;z A&ndash;Z . / - _ ~ ' + & ? = &#xA1; &#xA8; &#xBF;&ndash;&#xD6; &#xD8;&ndash;&#xF6;
     * &#xF8;&ndash;&#xFF;</span><br /><br /> Before adding targets, specified values are <b>transformed</b> so all whitespace (multiple spaces, tabs, new lines etc.) is replaced with single spaces, all remaining leading or trailing whitespace is trimmed,
     * strings like&nbsp; <span class="showcode">www.</span>&nbsp and&nbsp; <span class="showcode">http://</span>&nbsp are removed from the beginning of targets, any leading or trailing characters&nbsp; <span class="showcode">+ - .</span>&nbsp are trimmed,
     * and any trailing character&nbsp; <span class="showcode">/</span>&nbsp; is trimmed.<br /><br /> Minimum length for a target is <b>two</b> characters.&nbsp; Maximum length for a target is <b>100</b> characters for URL and <b>244</b> characters for
     * other keyword.&nbsp; Target is allowed to have at most <b>eight</b> subwords.
     * @var string
     */
    public $target;
    /**
     * The maxBid
     * Meta information extracted from the WSDL
     * - documentation: Value type used for specifying target definition data while adding new targets into your creatives.<br /> Please note that <b>targeted region</b> is inherited by the targets from the creative into which new targets are actually
     * added.<br /><br /> UTF-8 <b>characters allowed</b> within targets are including the following:&nbsp; <span class="showcode">0&ndash;9 a&ndash;z A&ndash;Z . / - _ ~ ' + & ? = &#xA1; &#xA8; &#xBF;&ndash;&#xD6; &#xD8;&ndash;&#xF6;
     * &#xF8;&ndash;&#xFF;</span><br /><br /> Before adding targets, specified values are <b>transformed</b> so all whitespace (multiple spaces, tabs, new lines etc.) is replaced with single spaces, all remaining leading or trailing whitespace is trimmed,
     * strings like&nbsp; <span class="showcode">www.</span>&nbsp and&nbsp; <span class="showcode">http://</span>&nbsp are removed from the beginning of targets, any leading or trailing characters&nbsp; <span class="showcode">+ - .</span>&nbsp are trimmed,
     * and any trailing character&nbsp; <span class="showcode">/</span>&nbsp; is trimmed.<br /><br /> Minimum length for a target is <b>two</b> characters.&nbsp; Maximum length for a target is <b>100</b> characters for URL and <b>244</b> characters for
     * other keyword.&nbsp; Target is allowed to have at most <b>eight</b> subwords.
     * @var float
     */
    public $maxBid;
    /**
     * Constructor method for TargetAdd
     * @uses TargetAdd::setTarget()
     * @uses TargetAdd::setMaxBid()
     * @param string $target
     * @param float $maxBid
     */
    public function __construct($target = null, $maxBid = null)
    {
        $this
            ->setTarget($target)
            ->setMaxBid($maxBid);
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\TargetAdd
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get maxBid value
     * @return float|null
     */
    public function getMaxBid()
    {
        return $this->maxBid;
    }
    /**
     * Set maxBid value
     * @param float $maxBid
     * @return \StructType\TargetAdd
     */
    public function setMaxBid($maxBid = null)
    {
        // validation for constraint: float
        if (!is_null($maxBid) && !(is_float($maxBid) || is_numeric($maxBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxBid, true), gettype($maxBid)), __LINE__);
        }
        $this->maxBid = $maxBid;
        return $this;
    }
}
