<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticateRequest SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticateRequest $authenticateRequest
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticateRequest(\StructType\AuthenticateRequest $authenticateRequest, $nameSpace = 'https://apitest.trafficvance.com/?v3=targets', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticateRequest', $authenticateRequest, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named updateTargets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Performs changes to your already existing targets, by changing the max. bids.&nbsp; Please note that stored max. bids can be <b>different</b> than the specified values, due to rounding or your minimal and maximal allowed bids; see
     * type&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=Target">Target</a></span>&nbsp; and operation&nbsp; <span class="showcode"><a href="{SystemService}#getRegions">getRegions()</a></span>&nbsp; for more details. | Performs changes to
     * your already existing targets, by changing the max. bids.&nbsp; Please note that stored max. bids can be <b>different</b> than the specified values, due to rounding or your minimal and maximal allowed bids; see type&nbsp; <span class="showcode"><a
     * href="/?docs=v3.Index&className=Target">Target</a></span>&nbsp; and operation&nbsp; <span class="showcode"><a href="{SystemService}#getRegions">getRegions()</a></span>&nbsp; for more details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTargetsParameters $parameters
     * @return \StructType\TargetsUpdateResult|bool
     */
    public function updateTargets(\StructType\UpdateTargetsParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTargets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TargetsUpdateResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
