<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticateRequest SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticateRequest $authenticateRequest
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticateRequest(\StructType\AuthenticateRequest $authenticateRequest, $nameSpace = 'https://apitest.trafficvance.com/?v3=targets', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticateRequest', $authenticateRequest, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getTargetIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Returns the list of compound ID values for your targets belonging to your selected campaigns and/or creatives.&nbsp; Please note that it is <b>not allowed</b> to specify both campaigns and creatives filters as <b>Null</b>, at least
     * one of them is required. | Returns the list of compound ID values for your targets belonging to your selected campaigns and/or creatives.&nbsp; Please note that it is <b>not allowed</b> to specify both campaigns and creatives filters as <b>Null</b>,
     * at least one of them is required.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTargetIdsParameters $parameters
     * @return \StructType\TargetIdsResult|bool
     */
    public function getTargetIds(\StructType\GetTargetIdsParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTargetIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTargets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Returns the parameters stored for your already existing targets, please see type&nbsp; <span class="showcode"><a href="{TargetsService}#Target">Target</a></span>&nbsp; for more details. | Returns the parameters stored for your
     * already existing targets, please see type&nbsp; <span class="showcode"><a href="{TargetsService}#Target">Target</a></span>&nbsp; for more details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTargetsParameters $parameters
     * @return \StructType\TargetsResult|bool
     */
    public function getTargets(\StructType\GetTargetsParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTargets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCategories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Returns all currently available NLP topics.&nbsp; Please note that if you want to use NLP topic add id value to target value in <span class="showcode"><a href="/?docs=v3.Index&className=TargetAdd">TargetAdd</a></span> see type&nbsp;
     * <span class="showcode"><a href="/?docs=v3.Index&className=Category">Category</a></span>&nbsp; for more details. | Returns all currently available NLP topics.&nbsp; Please note that if you want to use NLP topic add id value to target value in <span
     * class="showcode"><a href="/?docs=v3.Index&className=TargetAdd">TargetAdd</a></span> see type&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=Category">Category</a></span>&nbsp; for more details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\CategoriesResult|bool
     */
    public function getCategories()
    {
        try {
            $this->setResult($this->getSoapClient()->getCategories());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSuggested
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticateRequest
     * - SOAPHeaderNamespaces: https://apitest.trafficvance.com/?v3=targets
     * - SOAPHeaderTypes: \StructType\AuthenticateRequest
     * - SOAPHeaders: required
     * - documentation: Returns suggested targets that can be used within your creatives.&nbsp; Please note that for each request at most <b>1,000</b> suggested targets currently having highest activity are returned, see type&nbsp; <span class="showcode"><a
     * href="/?docs=v3.Index&className=TargetSuggested">TargetSuggested</a></span>&nbsp; for more details. | Returns suggested targets that can be used within your creatives.&nbsp; Please note that for each request at most <b>1,000</b> suggested targets
     * currently having highest activity are returned, see type&nbsp; <span class="showcode"><a href="/?docs=v3.Index&className=TargetSuggested">TargetSuggested</a></span>&nbsp; for more details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSuggestedParameters $parameters
     * @return \StructType\TargetsSuggestResult|bool
     */
    public function getSuggested(\StructType\GetSuggestedParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSuggested($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CategoriesResult|\StructType\TargetIdsResult|\StructType\TargetsResult|\StructType\TargetsSuggestResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
