<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewCommissionInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewCommissionInfo
 * @subpackage Structs
 */
class ViewCommissionInfo extends AbstractStructBase
{
    /**
     * The AgencyCommissions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCommissionInfo
     */
    public $AgencyCommissions;
    /**
     * The TotalCommissions
     * @var float
     */
    public $TotalCommissions;
    /**
     * The TotalFares
     * @var float
     */
    public $TotalFares;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewCommissionInfo
     * @uses ViewCommissionInfo::setAgencyCommissions()
     * @uses ViewCommissionInfo::setTotalCommissions()
     * @uses ViewCommissionInfo::setTotalFares()
     * @uses ViewCommissionInfo::setExceptions()
     * @param \ArrayType\ArrayOfCommissionInfo $agencyCommissions
     * @param float $totalCommissions
     * @param float $totalFares
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\ArrayType\ArrayOfCommissionInfo $agencyCommissions = null, $totalCommissions = null, $totalFares = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setAgencyCommissions($agencyCommissions)
            ->setTotalCommissions($totalCommissions)
            ->setTotalFares($totalFares)
            ->setExceptions($exceptions);
    }
    /**
     * Get AgencyCommissions value
     * @return \ArrayType\ArrayOfCommissionInfo|null
     */
    public function getAgencyCommissions()
    {
        return $this->AgencyCommissions;
    }
    /**
     * Set AgencyCommissions value
     * @param \ArrayType\ArrayOfCommissionInfo $agencyCommissions
     * @return \StructType\ViewCommissionInfo
     */
    public function setAgencyCommissions(\ArrayType\ArrayOfCommissionInfo $agencyCommissions = null)
    {
        $this->AgencyCommissions = $agencyCommissions;
        return $this;
    }
    /**
     * Get TotalCommissions value
     * @return float|null
     */
    public function getTotalCommissions()
    {
        return $this->TotalCommissions;
    }
    /**
     * Set TotalCommissions value
     * @param float $totalCommissions
     * @return \StructType\ViewCommissionInfo
     */
    public function setTotalCommissions($totalCommissions = null)
    {
        // validation for constraint: float
        if (!is_null($totalCommissions) && !(is_float($totalCommissions) || is_numeric($totalCommissions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCommissions, true), gettype($totalCommissions)), __LINE__);
        }
        $this->TotalCommissions = $totalCommissions;
        return $this;
    }
    /**
     * Get TotalFares value
     * @return float|null
     */
    public function getTotalFares()
    {
        return $this->TotalFares;
    }
    /**
     * Set TotalFares value
     * @param float $totalFares
     * @return \StructType\ViewCommissionInfo
     */
    public function setTotalFares($totalFares = null)
    {
        // validation for constraint: float
        if (!is_null($totalFares) && !(is_float($totalFares) || is_numeric($totalFares))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFares, true), gettype($totalFares)), __LINE__);
        }
        $this->TotalFares = $totalFares;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewCommissionInfo
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
