<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewBookingsWithPaymentsPending StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewBookingsWithPaymentsPending
 * @subpackage Structs
 */
class ViewBookingsWithPaymentsPending extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The PaymentDue
     * @var string
     */
    public $PaymentDue;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DepartureAirport;
    /**
     * Constructor method for ViewBookingsWithPaymentsPending
     * @uses ViewBookingsWithPaymentsPending::setSeriesNumber()
     * @uses ViewBookingsWithPaymentsPending::setConfirmationNumber()
     * @uses ViewBookingsWithPaymentsPending::setLastName()
     * @uses ViewBookingsWithPaymentsPending::setFirstName()
     * @uses ViewBookingsWithPaymentsPending::setTitle()
     * @uses ViewBookingsWithPaymentsPending::setCountryCode()
     * @uses ViewBookingsWithPaymentsPending::setPhoneNumber()
     * @uses ViewBookingsWithPaymentsPending::setAmount()
     * @uses ViewBookingsWithPaymentsPending::setCurrency()
     * @uses ViewBookingsWithPaymentsPending::setPaymentDue()
     * @uses ViewBookingsWithPaymentsPending::setDepartureAirport()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $lastName
     * @param string $firstName
     * @param string $title
     * @param string $countryCode
     * @param string $phoneNumber
     * @param float $amount
     * @param string $currency
     * @param string $paymentDue
     * @param string $departureAirport
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $lastName = null, $firstName = null, $title = null, $countryCode = null, $phoneNumber = null, $amount = null, $currency = null, $paymentDue = null, $departureAirport = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setTitle($title)
            ->setCountryCode($countryCode)
            ->setPhoneNumber($phoneNumber)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setPaymentDue($paymentDue)
            ->setDepartureAirport($departureAirport);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get PaymentDue value
     * @return string|null
     */
    public function getPaymentDue()
    {
        return $this->PaymentDue;
    }
    /**
     * Set PaymentDue value
     * @param string $paymentDue
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setPaymentDue($paymentDue = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDue) && !is_string($paymentDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDue, true), gettype($paymentDue)), __LINE__);
        }
        $this->PaymentDue = $paymentDue;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return string|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param string $departureAirport
     * @return \StructType\ViewBookingsWithPaymentsPending
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirport, true), gettype($departureAirport)), __LINE__);
        }
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
}
