<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelAgencyCommission StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TravelAgencyCommission
 * @subpackage Structs
 */
class TravelAgencyCommission extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The IsPercentage
     * @var bool
     */
    public $IsPercentage;
    /**
     * The MinAmount
     * @var float
     */
    public $MinAmount;
    /**
     * The MaxAmount
     * @var float
     */
    public $MaxAmount;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The AssessAsFee
     * @var bool
     */
    public $AssessAsFee;
    /**
     * Constructor method for TravelAgencyCommission
     * @uses TravelAgencyCommission::setAmount()
     * @uses TravelAgencyCommission::setIsPercentage()
     * @uses TravelAgencyCommission::setMinAmount()
     * @uses TravelAgencyCommission::setMaxAmount()
     * @uses TravelAgencyCommission::setPaymentMethod()
     * @uses TravelAgencyCommission::setAssessAsFee()
     * @param float $amount
     * @param bool $isPercentage
     * @param float $minAmount
     * @param float $maxAmount
     * @param string $paymentMethod
     * @param bool $assessAsFee
     */
    public function __construct($amount = null, $isPercentage = null, $minAmount = null, $maxAmount = null, $paymentMethod = null, $assessAsFee = null)
    {
        $this
            ->setAmount($amount)
            ->setIsPercentage($isPercentage)
            ->setMinAmount($minAmount)
            ->setMaxAmount($maxAmount)
            ->setPaymentMethod($paymentMethod)
            ->setAssessAsFee($assessAsFee);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\TravelAgencyCommission
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get IsPercentage value
     * @return bool|null
     */
    public function getIsPercentage()
    {
        return $this->IsPercentage;
    }
    /**
     * Set IsPercentage value
     * @param bool $isPercentage
     * @return \StructType\TravelAgencyCommission
     */
    public function setIsPercentage($isPercentage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPercentage) && !is_bool($isPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPercentage, true), gettype($isPercentage)), __LINE__);
        }
        $this->IsPercentage = $isPercentage;
        return $this;
    }
    /**
     * Get MinAmount value
     * @return float|null
     */
    public function getMinAmount()
    {
        return $this->MinAmount;
    }
    /**
     * Set MinAmount value
     * @param float $minAmount
     * @return \StructType\TravelAgencyCommission
     */
    public function setMinAmount($minAmount = null)
    {
        // validation for constraint: float
        if (!is_null($minAmount) && !(is_float($minAmount) || is_numeric($minAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minAmount, true), gettype($minAmount)), __LINE__);
        }
        $this->MinAmount = $minAmount;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float|null
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\TravelAgencyCommission
     */
    public function setMaxAmount($maxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($maxAmount) && !(is_float($maxAmount) || is_numeric($maxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxAmount, true), gettype($maxAmount)), __LINE__);
        }
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \StructType\TravelAgencyCommission
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get AssessAsFee value
     * @return bool|null
     */
    public function getAssessAsFee()
    {
        return $this->AssessAsFee;
    }
    /**
     * Set AssessAsFee value
     * @param bool $assessAsFee
     * @return \StructType\TravelAgencyCommission
     */
    public function setAssessAsFee($assessAsFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($assessAsFee) && !is_bool($assessAsFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($assessAsFee, true), gettype($assessAsFee)), __LINE__);
        }
        $this->AssessAsFee = $assessAsFee;
        return $this;
    }
}
