<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveBookingHistory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveBookingHistory
 * @subpackage Structs
 */
class RetrieveBookingHistory extends TransactionInfo
{
    /**
     * The RetrieveBookingHistoryRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveBookingHistory
     */
    public $RetrieveBookingHistoryRequest;
    /**
     * The BookingDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingDateFrom;
    /**
     * The BookingDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingDateTo;
    /**
     * The BookingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingType;
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATA;
    /**
     * The IncludeChildAgency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeChildAgency;
    /**
     * Constructor method for RetrieveBookingHistory
     * @uses RetrieveBookingHistory::setRetrieveBookingHistoryRequest()
     * @uses RetrieveBookingHistory::setBookingDateFrom()
     * @uses RetrieveBookingHistory::setBookingDateTo()
     * @uses RetrieveBookingHistory::setBookingType()
     * @uses RetrieveBookingHistory::setIATA()
     * @uses RetrieveBookingHistory::setIncludeChildAgency()
     * @param \StructType\RetrieveBookingHistory $retrieveBookingHistoryRequest
     * @param string $bookingDateFrom
     * @param string $bookingDateTo
     * @param string $bookingType
     * @param string $iATA
     * @param string $includeChildAgency
     */
    public function __construct(\StructType\RetrieveBookingHistory $retrieveBookingHistoryRequest = null, $bookingDateFrom = null, $bookingDateTo = null, $bookingType = null, $iATA = null, $includeChildAgency = null)
    {
        $this
            ->setRetrieveBookingHistoryRequest($retrieveBookingHistoryRequest)
            ->setBookingDateFrom($bookingDateFrom)
            ->setBookingDateTo($bookingDateTo)
            ->setBookingType($bookingType)
            ->setIATA($iATA)
            ->setIncludeChildAgency($includeChildAgency);
    }
    /**
     * Get RetrieveBookingHistoryRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveBookingHistory|null
     */
    public function getRetrieveBookingHistoryRequest()
    {
        return isset($this->RetrieveBookingHistoryRequest) ? $this->RetrieveBookingHistoryRequest : null;
    }
    /**
     * Set RetrieveBookingHistoryRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveBookingHistory $retrieveBookingHistoryRequest
     * @return \StructType\RetrieveBookingHistory
     */
    public function setRetrieveBookingHistoryRequest(\StructType\RetrieveBookingHistory $retrieveBookingHistoryRequest = null)
    {
        if (is_null($retrieveBookingHistoryRequest) || (is_array($retrieveBookingHistoryRequest) && empty($retrieveBookingHistoryRequest))) {
            unset($this->RetrieveBookingHistoryRequest);
        } else {
            $this->RetrieveBookingHistoryRequest = $retrieveBookingHistoryRequest;
        }
        return $this;
    }
    /**
     * Get BookingDateFrom value
     * @return string|null
     */
    public function getBookingDateFrom()
    {
        return $this->BookingDateFrom;
    }
    /**
     * Set BookingDateFrom value
     * @param string $bookingDateFrom
     * @return \StructType\RetrieveBookingHistory
     */
    public function setBookingDateFrom($bookingDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDateFrom) && !is_string($bookingDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDateFrom, true), gettype($bookingDateFrom)), __LINE__);
        }
        $this->BookingDateFrom = $bookingDateFrom;
        return $this;
    }
    /**
     * Get BookingDateTo value
     * @return string|null
     */
    public function getBookingDateTo()
    {
        return $this->BookingDateTo;
    }
    /**
     * Set BookingDateTo value
     * @param string $bookingDateTo
     * @return \StructType\RetrieveBookingHistory
     */
    public function setBookingDateTo($bookingDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDateTo) && !is_string($bookingDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDateTo, true), gettype($bookingDateTo)), __LINE__);
        }
        $this->BookingDateTo = $bookingDateTo;
        return $this;
    }
    /**
     * Get BookingType value
     * @return string|null
     */
    public function getBookingType()
    {
        return $this->BookingType;
    }
    /**
     * Set BookingType value
     * @uses \EnumType\Enumerations_PNRStatus::valueIsValid()
     * @uses \EnumType\Enumerations_PNRStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingType
     * @return \StructType\RetrieveBookingHistory
     */
    public function setBookingType($bookingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PNRStatus::valueIsValid($bookingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PNRStatus', is_array($bookingType) ? implode(', ', $bookingType) : var_export($bookingType, true), implode(', ', \EnumType\Enumerations_PNRStatus::getValidValues())), __LINE__);
        }
        $this->BookingType = $bookingType;
        return $this;
    }
    /**
     * Get IATA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATA()
    {
        return isset($this->IATA) ? $this->IATA : null;
    }
    /**
     * Set IATA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATA
     * @return \StructType\RetrieveBookingHistory
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        if (is_null($iATA) || (is_array($iATA) && empty($iATA))) {
            unset($this->IATA);
        } else {
            $this->IATA = $iATA;
        }
        return $this;
    }
    /**
     * Get IncludeChildAgency value
     * @return string|null
     */
    public function getIncludeChildAgency()
    {
        return $this->IncludeChildAgency;
    }
    /**
     * Set IncludeChildAgency value
     * @uses \EnumType\Enumerations_AnswerTypes::valueIsValid()
     * @uses \EnumType\Enumerations_AnswerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeChildAgency
     * @return \StructType\RetrieveBookingHistory
     */
    public function setIncludeChildAgency($includeChildAgency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AnswerTypes::valueIsValid($includeChildAgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AnswerTypes', is_array($includeChildAgency) ? implode(', ', $includeChildAgency) : var_export($includeChildAgency, true), implode(', ', \EnumType\Enumerations_AnswerTypes::getValidValues())), __LINE__);
        }
        $this->IncludeChildAgency = $includeChildAgency;
        return $this;
    }
}
