<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgencyList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgencyList
 * @subpackage Structs
 */
class RetrieveAgencyList extends TransactionInfo
{
    /**
     * The retrieveAgencyListRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgencyList
     */
    public $retrieveAgencyListRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The IncludeChildAgents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeChildAgents;
    /**
     * Constructor method for RetrieveAgencyList
     * @uses RetrieveAgencyList::setRetrieveAgencyListRequest()
     * @uses RetrieveAgencyList::setIATANumber()
     * @uses RetrieveAgencyList::setIncludeChildAgents()
     * @param \StructType\RetrieveAgencyList $retrieveAgencyListRequest
     * @param string $iATANumber
     * @param bool $includeChildAgents
     */
    public function __construct(\StructType\RetrieveAgencyList $retrieveAgencyListRequest = null, $iATANumber = null, $includeChildAgents = null)
    {
        $this
            ->setRetrieveAgencyListRequest($retrieveAgencyListRequest)
            ->setIATANumber($iATANumber)
            ->setIncludeChildAgents($includeChildAgents);
    }
    /**
     * Get retrieveAgencyListRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgencyList|null
     */
    public function getRetrieveAgencyListRequest()
    {
        return isset($this->retrieveAgencyListRequest) ? $this->retrieveAgencyListRequest : null;
    }
    /**
     * Set retrieveAgencyListRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgencyList $retrieveAgencyListRequest
     * @return \StructType\RetrieveAgencyList
     */
    public function setRetrieveAgencyListRequest(\StructType\RetrieveAgencyList $retrieveAgencyListRequest = null)
    {
        if (is_null($retrieveAgencyListRequest) || (is_array($retrieveAgencyListRequest) && empty($retrieveAgencyListRequest))) {
            unset($this->retrieveAgencyListRequest);
        } else {
            $this->retrieveAgencyListRequest = $retrieveAgencyListRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\RetrieveAgencyList
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
    /**
     * Get IncludeChildAgents value
     * @return bool|null
     */
    public function getIncludeChildAgents()
    {
        return $this->IncludeChildAgents;
    }
    /**
     * Set IncludeChildAgents value
     * @param bool $includeChildAgents
     * @return \StructType\RetrieveAgencyList
     */
    public function setIncludeChildAgents($includeChildAgents = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildAgents) && !is_bool($includeChildAgents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildAgents, true), gettype($includeChildAgents)), __LINE__);
        }
        $this->IncludeChildAgents = $includeChildAgents;
        return $this;
    }
}
