<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DashboardViewInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DashboardViewInfo
 * @subpackage Structs
 */
class DashboardViewInfo extends TransactionInfo
{
    /**
     * The AgencyIATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyIATANumber;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The RequestedStartDate
     * @var string
     */
    public $RequestedStartDate;
    /**
     * The RequestedEndDate
     * @var string
     */
    public $RequestedEndDate;
    /**
     * The IncludeChildAgentInfo
     * @var bool
     */
    public $IncludeChildAgentInfo;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * Constructor method for DashboardViewInfo
     * @uses DashboardViewInfo::setAgencyIATANumber()
     * @uses DashboardViewInfo::setAgencyName()
     * @uses DashboardViewInfo::setRequestedStartDate()
     * @uses DashboardViewInfo::setRequestedEndDate()
     * @uses DashboardViewInfo::setIncludeChildAgentInfo()
     * @uses DashboardViewInfo::setEmailAddress()
     * @param string $agencyIATANumber
     * @param string $agencyName
     * @param string $requestedStartDate
     * @param string $requestedEndDate
     * @param bool $includeChildAgentInfo
     * @param string $emailAddress
     */
    public function __construct($agencyIATANumber = null, $agencyName = null, $requestedStartDate = null, $requestedEndDate = null, $includeChildAgentInfo = null, $emailAddress = null)
    {
        $this
            ->setAgencyIATANumber($agencyIATANumber)
            ->setAgencyName($agencyName)
            ->setRequestedStartDate($requestedStartDate)
            ->setRequestedEndDate($requestedEndDate)
            ->setIncludeChildAgentInfo($includeChildAgentInfo)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get AgencyIATANumber value
     * @return string|null
     */
    public function getAgencyIATANumber()
    {
        return $this->AgencyIATANumber;
    }
    /**
     * Set AgencyIATANumber value
     * @param string $agencyIATANumber
     * @return \StructType\DashboardViewInfo
     */
    public function setAgencyIATANumber($agencyIATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($agencyIATANumber) && !is_string($agencyIATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyIATANumber, true), gettype($agencyIATANumber)), __LINE__);
        }
        $this->AgencyIATANumber = $agencyIATANumber;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\DashboardViewInfo
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Get RequestedStartDate value
     * @return string|null
     */
    public function getRequestedStartDate()
    {
        return $this->RequestedStartDate;
    }
    /**
     * Set RequestedStartDate value
     * @param string $requestedStartDate
     * @return \StructType\DashboardViewInfo
     */
    public function setRequestedStartDate($requestedStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedStartDate) && !is_string($requestedStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedStartDate, true), gettype($requestedStartDate)), __LINE__);
        }
        $this->RequestedStartDate = $requestedStartDate;
        return $this;
    }
    /**
     * Get RequestedEndDate value
     * @return string|null
     */
    public function getRequestedEndDate()
    {
        return $this->RequestedEndDate;
    }
    /**
     * Set RequestedEndDate value
     * @param string $requestedEndDate
     * @return \StructType\DashboardViewInfo
     */
    public function setRequestedEndDate($requestedEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedEndDate) && !is_string($requestedEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedEndDate, true), gettype($requestedEndDate)), __LINE__);
        }
        $this->RequestedEndDate = $requestedEndDate;
        return $this;
    }
    /**
     * Get IncludeChildAgentInfo value
     * @return bool|null
     */
    public function getIncludeChildAgentInfo()
    {
        return $this->IncludeChildAgentInfo;
    }
    /**
     * Set IncludeChildAgentInfo value
     * @param bool $includeChildAgentInfo
     * @return \StructType\DashboardViewInfo
     */
    public function setIncludeChildAgentInfo($includeChildAgentInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildAgentInfo) && !is_bool($includeChildAgentInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildAgentInfo, true), gettype($includeChildAgentInfo)), __LINE__);
        }
        $this->IncludeChildAgentInfo = $includeChildAgentInfo;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\DashboardViewInfo
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
}
