<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChargeCode
 * @subpackage Structs
 */
class ChargeCode extends AbstractStructBase
{
    /**
     * The CodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeType;
    /**
     * Constructor method for ChargeCode
     * @uses ChargeCode::setCodeType()
     * @param string $codeType
     */
    public function __construct($codeType = null)
    {
        $this
            ->setCodeType($codeType);
    }
    /**
     * Get CodeType value
     * @return string|null
     */
    public function getCodeType()
    {
        return $this->CodeType;
    }
    /**
     * Set CodeType value
     * @param string $codeType
     * @return \StructType\ChargeCode
     */
    public function setCodeType($codeType = null)
    {
        // validation for constraint: string
        if (!is_null($codeType) && !is_string($codeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeType, true), gettype($codeType)), __LINE__);
        }
        $this->CodeType = $codeType;
        return $this;
    }
}
