<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BalanceInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BalanceInfo
 * @subpackage Structs
 */
class BalanceInfo extends AbstractStructBase
{
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookingUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingUserName;
    /**
     * The OriginatingAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginatingAirport;
    /**
     * The DestinationAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DestinationAirport;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The BookingDate
     * @var string
     */
    public $BookingDate;
    /**
     * The BookingCurrency
     * @var string
     */
    public $BookingCurrency;
    /**
     * The BookingAmount
     * @var float
     */
    public $BookingAmount;
    /**
     * The PaymentDate
     * @var string
     */
    public $PaymentDate;
    /**
     * The PaymentUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentUserName;
    /**
     * The PaymentReference
     * @var int
     */
    public $PaymentReference;
    /**
     * The PaymentCurrency
     * @var string
     */
    public $PaymentCurrency;
    /**
     * The PaymentAmount
     * @var float
     */
    public $PaymentAmount;
    /**
     * The PassengerCount
     * @var int
     */
    public $PassengerCount;
    /**
     * The SegmentCount
     * @var int
     */
    public $SegmentCount;
    /**
     * The PrimaryPassengerName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PrimaryPassengerName;
    /**
     * The BalanceDue
     * @var float
     */
    public $BalanceDue;
    /**
     * The DepositDate
     * @var string
     */
    public $DepositDate;
    /**
     * The DepositAmount
     * @var float
     */
    public $DepositAmount;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for BalanceInfo
     * @uses BalanceInfo::setInvoiceNumber()
     * @uses BalanceInfo::setConfirmationNumber()
     * @uses BalanceInfo::setBookingUserName()
     * @uses BalanceInfo::setOriginatingAirport()
     * @uses BalanceInfo::setDestinationAirport()
     * @uses BalanceInfo::setIATANumber()
     * @uses BalanceInfo::setBookingDate()
     * @uses BalanceInfo::setBookingCurrency()
     * @uses BalanceInfo::setBookingAmount()
     * @uses BalanceInfo::setPaymentDate()
     * @uses BalanceInfo::setPaymentUserName()
     * @uses BalanceInfo::setPaymentReference()
     * @uses BalanceInfo::setPaymentCurrency()
     * @uses BalanceInfo::setPaymentAmount()
     * @uses BalanceInfo::setPassengerCount()
     * @uses BalanceInfo::setSegmentCount()
     * @uses BalanceInfo::setPrimaryPassengerName()
     * @uses BalanceInfo::setBalanceDue()
     * @uses BalanceInfo::setDepositDate()
     * @uses BalanceInfo::setDepositAmount()
     * @uses BalanceInfo::setDepartureDate()
     * @uses BalanceInfo::setComments()
     * @param string $invoiceNumber
     * @param string $confirmationNumber
     * @param string $bookingUserName
     * @param string $originatingAirport
     * @param string $destinationAirport
     * @param string $iATANumber
     * @param string $bookingDate
     * @param string $bookingCurrency
     * @param float $bookingAmount
     * @param string $paymentDate
     * @param string $paymentUserName
     * @param int $paymentReference
     * @param string $paymentCurrency
     * @param float $paymentAmount
     * @param int $passengerCount
     * @param int $segmentCount
     * @param string $primaryPassengerName
     * @param float $balanceDue
     * @param string $depositDate
     * @param float $depositAmount
     * @param string $departureDate
     * @param string $comments
     */
    public function __construct($invoiceNumber = null, $confirmationNumber = null, $bookingUserName = null, $originatingAirport = null, $destinationAirport = null, $iATANumber = null, $bookingDate = null, $bookingCurrency = null, $bookingAmount = null, $paymentDate = null, $paymentUserName = null, $paymentReference = null, $paymentCurrency = null, $paymentAmount = null, $passengerCount = null, $segmentCount = null, $primaryPassengerName = null, $balanceDue = null, $depositDate = null, $depositAmount = null, $departureDate = null, $comments = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setBookingUserName($bookingUserName)
            ->setOriginatingAirport($originatingAirport)
            ->setDestinationAirport($destinationAirport)
            ->setIATANumber($iATANumber)
            ->setBookingDate($bookingDate)
            ->setBookingCurrency($bookingCurrency)
            ->setBookingAmount($bookingAmount)
            ->setPaymentDate($paymentDate)
            ->setPaymentUserName($paymentUserName)
            ->setPaymentReference($paymentReference)
            ->setPaymentCurrency($paymentCurrency)
            ->setPaymentAmount($paymentAmount)
            ->setPassengerCount($passengerCount)
            ->setSegmentCount($segmentCount)
            ->setPrimaryPassengerName($primaryPassengerName)
            ->setBalanceDue($balanceDue)
            ->setDepositDate($depositDate)
            ->setDepositAmount($depositAmount)
            ->setDepartureDate($departureDate)
            ->setComments($comments);
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\BalanceInfo
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\BalanceInfo
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get BookingUserName value
     * @return string|null
     */
    public function getBookingUserName()
    {
        return $this->BookingUserName;
    }
    /**
     * Set BookingUserName value
     * @param string $bookingUserName
     * @return \StructType\BalanceInfo
     */
    public function setBookingUserName($bookingUserName = null)
    {
        // validation for constraint: string
        if (!is_null($bookingUserName) && !is_string($bookingUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingUserName, true), gettype($bookingUserName)), __LINE__);
        }
        $this->BookingUserName = $bookingUserName;
        return $this;
    }
    /**
     * Get OriginatingAirport value
     * @return string|null
     */
    public function getOriginatingAirport()
    {
        return $this->OriginatingAirport;
    }
    /**
     * Set OriginatingAirport value
     * @param string $originatingAirport
     * @return \StructType\BalanceInfo
     */
    public function setOriginatingAirport($originatingAirport = null)
    {
        // validation for constraint: string
        if (!is_null($originatingAirport) && !is_string($originatingAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatingAirport, true), gettype($originatingAirport)), __LINE__);
        }
        $this->OriginatingAirport = $originatingAirport;
        return $this;
    }
    /**
     * Get DestinationAirport value
     * @return string|null
     */
    public function getDestinationAirport()
    {
        return $this->DestinationAirport;
    }
    /**
     * Set DestinationAirport value
     * @param string $destinationAirport
     * @return \StructType\BalanceInfo
     */
    public function setDestinationAirport($destinationAirport = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirport) && !is_string($destinationAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirport, true), gettype($destinationAirport)), __LINE__);
        }
        $this->DestinationAirport = $destinationAirport;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\BalanceInfo
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get BookingDate value
     * @return string|null
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param string $bookingDate
     * @return \StructType\BalanceInfo
     */
    public function setBookingDate($bookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDate) && !is_string($bookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDate, true), gettype($bookingDate)), __LINE__);
        }
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get BookingCurrency value
     * @return string|null
     */
    public function getBookingCurrency()
    {
        return $this->BookingCurrency;
    }
    /**
     * Set BookingCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingCurrency
     * @return \StructType\BalanceInfo
     */
    public function setBookingCurrency($bookingCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($bookingCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($bookingCurrency) ? implode(', ', $bookingCurrency) : var_export($bookingCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->BookingCurrency = $bookingCurrency;
        return $this;
    }
    /**
     * Get BookingAmount value
     * @return float|null
     */
    public function getBookingAmount()
    {
        return $this->BookingAmount;
    }
    /**
     * Set BookingAmount value
     * @param float $bookingAmount
     * @return \StructType\BalanceInfo
     */
    public function setBookingAmount($bookingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bookingAmount) && !(is_float($bookingAmount) || is_numeric($bookingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingAmount, true), gettype($bookingAmount)), __LINE__);
        }
        $this->BookingAmount = $bookingAmount;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\BalanceInfo
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get PaymentUserName value
     * @return string|null
     */
    public function getPaymentUserName()
    {
        return $this->PaymentUserName;
    }
    /**
     * Set PaymentUserName value
     * @param string $paymentUserName
     * @return \StructType\BalanceInfo
     */
    public function setPaymentUserName($paymentUserName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentUserName) && !is_string($paymentUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentUserName, true), gettype($paymentUserName)), __LINE__);
        }
        $this->PaymentUserName = $paymentUserName;
        return $this;
    }
    /**
     * Get PaymentReference value
     * @return int|null
     */
    public function getPaymentReference()
    {
        return $this->PaymentReference;
    }
    /**
     * Set PaymentReference value
     * @param int $paymentReference
     * @return \StructType\BalanceInfo
     */
    public function setPaymentReference($paymentReference = null)
    {
        // validation for constraint: int
        if (!is_null($paymentReference) && !(is_int($paymentReference) || ctype_digit($paymentReference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentReference, true), gettype($paymentReference)), __LINE__);
        }
        $this->PaymentReference = $paymentReference;
        return $this;
    }
    /**
     * Get PaymentCurrency value
     * @return string|null
     */
    public function getPaymentCurrency()
    {
        return $this->PaymentCurrency;
    }
    /**
     * Set PaymentCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentCurrency
     * @return \StructType\BalanceInfo
     */
    public function setPaymentCurrency($paymentCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($paymentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($paymentCurrency) ? implode(', ', $paymentCurrency) : var_export($paymentCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->PaymentCurrency = $paymentCurrency;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\BalanceInfo
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get PassengerCount value
     * @return int|null
     */
    public function getPassengerCount()
    {
        return $this->PassengerCount;
    }
    /**
     * Set PassengerCount value
     * @param int $passengerCount
     * @return \StructType\BalanceInfo
     */
    public function setPassengerCount($passengerCount = null)
    {
        // validation for constraint: int
        if (!is_null($passengerCount) && !(is_int($passengerCount) || ctype_digit($passengerCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerCount, true), gettype($passengerCount)), __LINE__);
        }
        $this->PassengerCount = $passengerCount;
        return $this;
    }
    /**
     * Get SegmentCount value
     * @return int|null
     */
    public function getSegmentCount()
    {
        return $this->SegmentCount;
    }
    /**
     * Set SegmentCount value
     * @param int $segmentCount
     * @return \StructType\BalanceInfo
     */
    public function setSegmentCount($segmentCount = null)
    {
        // validation for constraint: int
        if (!is_null($segmentCount) && !(is_int($segmentCount) || ctype_digit($segmentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($segmentCount, true), gettype($segmentCount)), __LINE__);
        }
        $this->SegmentCount = $segmentCount;
        return $this;
    }
    /**
     * Get PrimaryPassengerName value
     * @return string|null
     */
    public function getPrimaryPassengerName()
    {
        return $this->PrimaryPassengerName;
    }
    /**
     * Set PrimaryPassengerName value
     * @param string $primaryPassengerName
     * @return \StructType\BalanceInfo
     */
    public function setPrimaryPassengerName($primaryPassengerName = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPassengerName) && !is_string($primaryPassengerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryPassengerName, true), gettype($primaryPassengerName)), __LINE__);
        }
        $this->PrimaryPassengerName = $primaryPassengerName;
        return $this;
    }
    /**
     * Get BalanceDue value
     * @return float|null
     */
    public function getBalanceDue()
    {
        return $this->BalanceDue;
    }
    /**
     * Set BalanceDue value
     * @param float $balanceDue
     * @return \StructType\BalanceInfo
     */
    public function setBalanceDue($balanceDue = null)
    {
        // validation for constraint: float
        if (!is_null($balanceDue) && !(is_float($balanceDue) || is_numeric($balanceDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balanceDue, true), gettype($balanceDue)), __LINE__);
        }
        $this->BalanceDue = $balanceDue;
        return $this;
    }
    /**
     * Get DepositDate value
     * @return string|null
     */
    public function getDepositDate()
    {
        return $this->DepositDate;
    }
    /**
     * Set DepositDate value
     * @param string $depositDate
     * @return \StructType\BalanceInfo
     */
    public function setDepositDate($depositDate = null)
    {
        // validation for constraint: string
        if (!is_null($depositDate) && !is_string($depositDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositDate, true), gettype($depositDate)), __LINE__);
        }
        $this->DepositDate = $depositDate;
        return $this;
    }
    /**
     * Get DepositAmount value
     * @return float|null
     */
    public function getDepositAmount()
    {
        return $this->DepositAmount;
    }
    /**
     * Set DepositAmount value
     * @param float $depositAmount
     * @return \StructType\BalanceInfo
     */
    public function setDepositAmount($depositAmount = null)
    {
        // validation for constraint: float
        if (!is_null($depositAmount) && !(is_float($depositAmount) || is_numeric($depositAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depositAmount, true), gettype($depositAmount)), __LINE__);
        }
        $this->DepositAmount = $depositAmount;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\BalanceInfo
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\BalanceInfo
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
}
