<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AgencyInfo
 * @subpackage Structs
 */
class AgencyInfo extends AbstractStructBase
{
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATA;
    /**
     * The Authentication_ID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Authentication_ID;
    /**
     * Constructor method for AgencyInfo
     * @uses AgencyInfo::setIATA()
     * @uses AgencyInfo::setAuthentication_ID()
     * @param string $iATA
     * @param string $authentication_ID
     */
    public function __construct($iATA = null, $authentication_ID = null)
    {
        $this
            ->setIATA($iATA)
            ->setAuthentication_ID($authentication_ID);
    }
    /**
     * Get IATA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATA()
    {
        return isset($this->IATA) ? $this->IATA : null;
    }
    /**
     * Set IATA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATA
     * @return \StructType\AgencyInfo
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        if (is_null($iATA) || (is_array($iATA) && empty($iATA))) {
            unset($this->IATA);
        } else {
            $this->IATA = $iATA;
        }
        return $this;
    }
    /**
     * Get Authentication_ID value
     * @return string|null
     */
    public function getAuthentication_ID()
    {
        return $this->Authentication_ID;
    }
    /**
     * Set Authentication_ID value
     * @param string $authentication_ID
     * @return \StructType\AgencyInfo
     */
    public function setAuthentication_ID($authentication_ID = null)
    {
        // validation for constraint: string
        if (!is_null($authentication_ID) && !is_string($authentication_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authentication_ID, true), gettype($authentication_ID)), __LINE__);
        }
        $this->Authentication_ID = $authentication_ID;
        return $this;
    }
}
