<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfViewAgent ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfViewAgent
 * @subpackage Arrays
 */
class ArrayOfViewAgent extends AbstractStructArrayBase
{
    /**
     * The ViewAgent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ViewAgent[]
     */
    public $ViewAgent;
    /**
     * Constructor method for ArrayOfViewAgent
     * @uses ArrayOfViewAgent::setViewAgent()
     * @param \StructType\ViewAgent[] $viewAgent
     */
    public function __construct(array $viewAgent = array())
    {
        $this
            ->setViewAgent($viewAgent);
    }
    /**
     * Get ViewAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ViewAgent[]|null
     */
    public function getViewAgent()
    {
        return isset($this->ViewAgent) ? $this->ViewAgent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setViewAgent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setViewAgent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViewAgentForArrayConstraintsFromSetViewAgent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfViewAgentViewAgentItem) {
            // validation for constraint: itemType
            if (!$arrayOfViewAgentViewAgentItem instanceof \StructType\ViewAgent) {
                $invalidValues[] = is_object($arrayOfViewAgentViewAgentItem) ? get_class($arrayOfViewAgentViewAgentItem) : sprintf('%s(%s)', gettype($arrayOfViewAgentViewAgentItem), var_export($arrayOfViewAgentViewAgentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ViewAgent property can only contain items of type \StructType\ViewAgent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ViewAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ViewAgent[] $viewAgent
     * @return \ArrayType\ArrayOfViewAgent
     */
    public function setViewAgent(array $viewAgent = array())
    {
        // validation for constraint: array
        if ('' !== ($viewAgentArrayErrorMessage = self::validateViewAgentForArrayConstraintsFromSetViewAgent($viewAgent))) {
            throw new \InvalidArgumentException($viewAgentArrayErrorMessage, __LINE__);
        }
        if (is_null($viewAgent) || (is_array($viewAgent) && empty($viewAgent))) {
            unset($this->ViewAgent);
        } else {
            $this->ViewAgent = $viewAgent;
        }
        return $this;
    }
    /**
     * Add item to ViewAgent value
     * @throws \InvalidArgumentException
     * @param \StructType\ViewAgent $item
     * @return \ArrayType\ArrayOfViewAgent
     */
    public function addToViewAgent(\StructType\ViewAgent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ViewAgent) {
            throw new \InvalidArgumentException(sprintf('The ViewAgent property can only contain items of type \StructType\ViewAgent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ViewAgent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ViewAgent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ViewAgent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ViewAgent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ViewAgent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ViewAgent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ViewAgent
     */
    public function getAttributeName()
    {
        return 'ViewAgent';
    }
}
