<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommissionInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCommissionInfo
 * @subpackage Arrays
 */
class ArrayOfCommissionInfo extends AbstractStructArrayBase
{
    /**
     * The CommissionInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CommissionInfo[]
     */
    public $CommissionInfo;
    /**
     * Constructor method for ArrayOfCommissionInfo
     * @uses ArrayOfCommissionInfo::setCommissionInfo()
     * @param \StructType\CommissionInfo[] $commissionInfo
     */
    public function __construct(array $commissionInfo = array())
    {
        $this
            ->setCommissionInfo($commissionInfo);
    }
    /**
     * Get CommissionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CommissionInfo[]|null
     */
    public function getCommissionInfo()
    {
        return isset($this->CommissionInfo) ? $this->CommissionInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCommissionInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommissionInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionInfoForArrayConstraintsFromSetCommissionInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCommissionInfoCommissionInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommissionInfoCommissionInfoItem instanceof \StructType\CommissionInfo) {
                $invalidValues[] = is_object($arrayOfCommissionInfoCommissionInfoItem) ? get_class($arrayOfCommissionInfoCommissionInfoItem) : sprintf('%s(%s)', gettype($arrayOfCommissionInfoCommissionInfoItem), var_export($arrayOfCommissionInfoCommissionInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommissionInfo property can only contain items of type \StructType\CommissionInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommissionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionInfo[] $commissionInfo
     * @return \ArrayType\ArrayOfCommissionInfo
     */
    public function setCommissionInfo(array $commissionInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionInfoArrayErrorMessage = self::validateCommissionInfoForArrayConstraintsFromSetCommissionInfo($commissionInfo))) {
            throw new \InvalidArgumentException($commissionInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($commissionInfo) || (is_array($commissionInfo) && empty($commissionInfo))) {
            unset($this->CommissionInfo);
        } else {
            $this->CommissionInfo = $commissionInfo;
        }
        return $this;
    }
    /**
     * Add item to CommissionInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionInfo $item
     * @return \ArrayType\ArrayOfCommissionInfo
     */
    public function addToCommissionInfo(\StructType\CommissionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionInfo) {
            throw new \InvalidArgumentException(sprintf('The CommissionInfo property can only contain items of type \StructType\CommissionInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommissionInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CommissionInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CommissionInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CommissionInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CommissionInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CommissionInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CommissionInfo
     */
    public function getAttributeName()
    {
        return 'CommissionInfo';
    }
}
