<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewTransactionInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewTransactionInfo
 * @subpackage Structs
 */
class ViewTransactionInfo extends AbstractStructBase
{
    /**
     * The AgencyTransactions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfTransactionInfo
     */
    public $AgencyTransactions;
    /**
     * The BeginningBalance
     * @var float
     */
    public $BeginningBalance;
    /**
     * The TotalDeposits
     * @var int
     */
    public $TotalDeposits;
    /**
     * The TotalCredits
     * @var int
     */
    public $TotalCredits;
    /**
     * The TotalDebits
     * @var int
     */
    public $TotalDebits;
    /**
     * The EndingBalance
     * @var float
     */
    public $EndingBalance;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewTransactionInfo
     * @uses ViewTransactionInfo::setAgencyTransactions()
     * @uses ViewTransactionInfo::setBeginningBalance()
     * @uses ViewTransactionInfo::setTotalDeposits()
     * @uses ViewTransactionInfo::setTotalCredits()
     * @uses ViewTransactionInfo::setTotalDebits()
     * @uses ViewTransactionInfo::setEndingBalance()
     * @uses ViewTransactionInfo::setExceptions()
     * @param \ArrayType\ArrayOfTransactionInfo $agencyTransactions
     * @param float $beginningBalance
     * @param int $totalDeposits
     * @param int $totalCredits
     * @param int $totalDebits
     * @param float $endingBalance
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\ArrayType\ArrayOfTransactionInfo $agencyTransactions = null, $beginningBalance = null, $totalDeposits = null, $totalCredits = null, $totalDebits = null, $endingBalance = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setAgencyTransactions($agencyTransactions)
            ->setBeginningBalance($beginningBalance)
            ->setTotalDeposits($totalDeposits)
            ->setTotalCredits($totalCredits)
            ->setTotalDebits($totalDebits)
            ->setEndingBalance($endingBalance)
            ->setExceptions($exceptions);
    }
    /**
     * Get AgencyTransactions value
     * @return \ArrayType\ArrayOfTransactionInfo|null
     */
    public function getAgencyTransactions()
    {
        return $this->AgencyTransactions;
    }
    /**
     * Set AgencyTransactions value
     * @param \ArrayType\ArrayOfTransactionInfo $agencyTransactions
     * @return \StructType\ViewTransactionInfo
     */
    public function setAgencyTransactions(\ArrayType\ArrayOfTransactionInfo $agencyTransactions = null)
    {
        $this->AgencyTransactions = $agencyTransactions;
        return $this;
    }
    /**
     * Get BeginningBalance value
     * @return float|null
     */
    public function getBeginningBalance()
    {
        return $this->BeginningBalance;
    }
    /**
     * Set BeginningBalance value
     * @param float $beginningBalance
     * @return \StructType\ViewTransactionInfo
     */
    public function setBeginningBalance($beginningBalance = null)
    {
        // validation for constraint: float
        if (!is_null($beginningBalance) && !(is_float($beginningBalance) || is_numeric($beginningBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($beginningBalance, true), gettype($beginningBalance)), __LINE__);
        }
        $this->BeginningBalance = $beginningBalance;
        return $this;
    }
    /**
     * Get TotalDeposits value
     * @return int|null
     */
    public function getTotalDeposits()
    {
        return $this->TotalDeposits;
    }
    /**
     * Set TotalDeposits value
     * @param int $totalDeposits
     * @return \StructType\ViewTransactionInfo
     */
    public function setTotalDeposits($totalDeposits = null)
    {
        // validation for constraint: int
        if (!is_null($totalDeposits) && !(is_int($totalDeposits) || ctype_digit($totalDeposits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDeposits, true), gettype($totalDeposits)), __LINE__);
        }
        $this->TotalDeposits = $totalDeposits;
        return $this;
    }
    /**
     * Get TotalCredits value
     * @return int|null
     */
    public function getTotalCredits()
    {
        return $this->TotalCredits;
    }
    /**
     * Set TotalCredits value
     * @param int $totalCredits
     * @return \StructType\ViewTransactionInfo
     */
    public function setTotalCredits($totalCredits = null)
    {
        // validation for constraint: int
        if (!is_null($totalCredits) && !(is_int($totalCredits) || ctype_digit($totalCredits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCredits, true), gettype($totalCredits)), __LINE__);
        }
        $this->TotalCredits = $totalCredits;
        return $this;
    }
    /**
     * Get TotalDebits value
     * @return int|null
     */
    public function getTotalDebits()
    {
        return $this->TotalDebits;
    }
    /**
     * Set TotalDebits value
     * @param int $totalDebits
     * @return \StructType\ViewTransactionInfo
     */
    public function setTotalDebits($totalDebits = null)
    {
        // validation for constraint: int
        if (!is_null($totalDebits) && !(is_int($totalDebits) || ctype_digit($totalDebits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDebits, true), gettype($totalDebits)), __LINE__);
        }
        $this->TotalDebits = $totalDebits;
        return $this;
    }
    /**
     * Get EndingBalance value
     * @return float|null
     */
    public function getEndingBalance()
    {
        return $this->EndingBalance;
    }
    /**
     * Set EndingBalance value
     * @param float $endingBalance
     * @return \StructType\ViewTransactionInfo
     */
    public function setEndingBalance($endingBalance = null)
    {
        // validation for constraint: float
        if (!is_null($endingBalance) && !(is_float($endingBalance) || is_numeric($endingBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($endingBalance, true), gettype($endingBalance)), __LINE__);
        }
        $this->EndingBalance = $endingBalance;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewTransactionInfo
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
