<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewDistributorDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewDistributorDetails
 * @subpackage Structs
 */
class ViewDistributorDetails extends AbstractStructBase
{
    /**
     * The DistributorName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistributorName;
    /**
     * The DistributorIATA
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistributorIATA;
    /**
     * The DistributorEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistributorEmail;
    /**
     * The DistributorCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistributorCurrency;
    /**
     * The DistributorCountry
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistributorCountry;
    /**
     * The DistributorStatus
     * @var string
     */
    public $DistributorStatus;
    /**
     * Constructor method for ViewDistributorDetails
     * @uses ViewDistributorDetails::setDistributorName()
     * @uses ViewDistributorDetails::setDistributorIATA()
     * @uses ViewDistributorDetails::setDistributorEmail()
     * @uses ViewDistributorDetails::setDistributorCurrency()
     * @uses ViewDistributorDetails::setDistributorCountry()
     * @uses ViewDistributorDetails::setDistributorStatus()
     * @param string $distributorName
     * @param string $distributorIATA
     * @param string $distributorEmail
     * @param string $distributorCurrency
     * @param string $distributorCountry
     * @param string $distributorStatus
     */
    public function __construct($distributorName = null, $distributorIATA = null, $distributorEmail = null, $distributorCurrency = null, $distributorCountry = null, $distributorStatus = null)
    {
        $this
            ->setDistributorName($distributorName)
            ->setDistributorIATA($distributorIATA)
            ->setDistributorEmail($distributorEmail)
            ->setDistributorCurrency($distributorCurrency)
            ->setDistributorCountry($distributorCountry)
            ->setDistributorStatus($distributorStatus);
    }
    /**
     * Get DistributorName value
     * @return string|null
     */
    public function getDistributorName()
    {
        return $this->DistributorName;
    }
    /**
     * Set DistributorName value
     * @param string $distributorName
     * @return \StructType\ViewDistributorDetails
     */
    public function setDistributorName($distributorName = null)
    {
        // validation for constraint: string
        if (!is_null($distributorName) && !is_string($distributorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributorName, true), gettype($distributorName)), __LINE__);
        }
        $this->DistributorName = $distributorName;
        return $this;
    }
    /**
     * Get DistributorIATA value
     * @return string|null
     */
    public function getDistributorIATA()
    {
        return $this->DistributorIATA;
    }
    /**
     * Set DistributorIATA value
     * @param string $distributorIATA
     * @return \StructType\ViewDistributorDetails
     */
    public function setDistributorIATA($distributorIATA = null)
    {
        // validation for constraint: string
        if (!is_null($distributorIATA) && !is_string($distributorIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributorIATA, true), gettype($distributorIATA)), __LINE__);
        }
        $this->DistributorIATA = $distributorIATA;
        return $this;
    }
    /**
     * Get DistributorEmail value
     * @return string|null
     */
    public function getDistributorEmail()
    {
        return $this->DistributorEmail;
    }
    /**
     * Set DistributorEmail value
     * @param string $distributorEmail
     * @return \StructType\ViewDistributorDetails
     */
    public function setDistributorEmail($distributorEmail = null)
    {
        // validation for constraint: string
        if (!is_null($distributorEmail) && !is_string($distributorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributorEmail, true), gettype($distributorEmail)), __LINE__);
        }
        $this->DistributorEmail = $distributorEmail;
        return $this;
    }
    /**
     * Get DistributorCurrency value
     * @return string|null
     */
    public function getDistributorCurrency()
    {
        return $this->DistributorCurrency;
    }
    /**
     * Set DistributorCurrency value
     * @param string $distributorCurrency
     * @return \StructType\ViewDistributorDetails
     */
    public function setDistributorCurrency($distributorCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($distributorCurrency) && !is_string($distributorCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributorCurrency, true), gettype($distributorCurrency)), __LINE__);
        }
        $this->DistributorCurrency = $distributorCurrency;
        return $this;
    }
    /**
     * Get DistributorCountry value
     * @return string|null
     */
    public function getDistributorCountry()
    {
        return $this->DistributorCountry;
    }
    /**
     * Set DistributorCountry value
     * @param string $distributorCountry
     * @return \StructType\ViewDistributorDetails
     */
    public function setDistributorCountry($distributorCountry = null)
    {
        // validation for constraint: string
        if (!is_null($distributorCountry) && !is_string($distributorCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributorCountry, true), gettype($distributorCountry)), __LINE__);
        }
        $this->DistributorCountry = $distributorCountry;
        return $this;
    }
    /**
     * Get DistributorStatus value
     * @return string|null
     */
    public function getDistributorStatus()
    {
        return $this->DistributorStatus;
    }
    /**
     * Set DistributorStatus value
     * @uses \EnumType\Enumerations_StatusTypes::valueIsValid()
     * @uses \EnumType\Enumerations_StatusTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributorStatus
     * @return \StructType\ViewDistributorDetails
     */
    public function setDistributorStatus($distributorStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_StatusTypes::valueIsValid($distributorStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_StatusTypes', is_array($distributorStatus) ? implode(', ', $distributorStatus) : var_export($distributorStatus, true), implode(', ', \EnumType\Enumerations_StatusTypes::getValidValues())), __LINE__);
        }
        $this->DistributorStatus = $distributorStatus;
        return $this;
    }
}
