<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewAgent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewAgent
 * @subpackage Structs
 */
class ViewAgent extends AbstractStructBase
{
    /**
     * The IataCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IataCode;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address1;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Status
     * @var int
     */
    public $Status;
    /**
     * The TelephoneNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TelephoneNumber;
    /**
     * The MobileNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MobileNumber;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The TravelAgentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelAgentType;
    /**
     * Constructor method for ViewAgent
     * @uses ViewAgent::setIataCode()
     * @uses ViewAgent::setUserId()
     * @uses ViewAgent::setUsername()
     * @uses ViewAgent::setCountry()
     * @uses ViewAgent::setFirstName()
     * @uses ViewAgent::setAddress()
     * @uses ViewAgent::setAddress1()
     * @uses ViewAgent::setCity()
     * @uses ViewAgent::setEmailAddress()
     * @uses ViewAgent::setLastName()
     * @uses ViewAgent::setPostalCode()
     * @uses ViewAgent::setState()
     * @uses ViewAgent::setStatus()
     * @uses ViewAgent::setTelephoneNumber()
     * @uses ViewAgent::setMobileNumber()
     * @uses ViewAgent::setExceptions()
     * @uses ViewAgent::setTravelAgentType()
     * @param string $iataCode
     * @param string $userId
     * @param string $username
     * @param string $country
     * @param string $firstName
     * @param string $address
     * @param string $address1
     * @param string $city
     * @param string $emailAddress
     * @param string $lastName
     * @param string $postalCode
     * @param string $state
     * @param int $status
     * @param string $telephoneNumber
     * @param string $mobileNumber
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @param string $travelAgentType
     */
    public function __construct($iataCode = null, $userId = null, $username = null, $country = null, $firstName = null, $address = null, $address1 = null, $city = null, $emailAddress = null, $lastName = null, $postalCode = null, $state = null, $status = null, $telephoneNumber = null, $mobileNumber = null, \StructType\ExceptionInformation_Exceptions $exceptions = null, $travelAgentType = null)
    {
        $this
            ->setIataCode($iataCode)
            ->setUserId($userId)
            ->setUsername($username)
            ->setCountry($country)
            ->setFirstName($firstName)
            ->setAddress($address)
            ->setAddress1($address1)
            ->setCity($city)
            ->setEmailAddress($emailAddress)
            ->setLastName($lastName)
            ->setPostalCode($postalCode)
            ->setState($state)
            ->setStatus($status)
            ->setTelephoneNumber($telephoneNumber)
            ->setMobileNumber($mobileNumber)
            ->setExceptions($exceptions)
            ->setTravelAgentType($travelAgentType);
    }
    /**
     * Get IataCode value
     * @return string|null
     */
    public function getIataCode()
    {
        return $this->IataCode;
    }
    /**
     * Set IataCode value
     * @param string $iataCode
     * @return \StructType\ViewAgent
     */
    public function setIataCode($iataCode = null)
    {
        // validation for constraint: string
        if (!is_null($iataCode) && !is_string($iataCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataCode, true), gettype($iataCode)), __LINE__);
        }
        $this->IataCode = $iataCode;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\ViewAgent
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ViewAgent
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\ViewAgent
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\ViewAgent
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ViewAgent
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\ViewAgent
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\ViewAgent
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\ViewAgent
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ViewAgent
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\ViewAgent
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\ViewAgent
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\ViewAgent
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\ViewAgent
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephoneNumber, true), gettype($telephoneNumber)), __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get MobileNumber value
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->MobileNumber;
    }
    /**
     * Set MobileNumber value
     * @param string $mobileNumber
     * @return \StructType\ViewAgent
     */
    public function setMobileNumber($mobileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNumber) && !is_string($mobileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileNumber, true), gettype($mobileNumber)), __LINE__);
        }
        $this->MobileNumber = $mobileNumber;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewAgent
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
    /**
     * Get TravelAgentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelAgentType()
    {
        return isset($this->TravelAgentType) ? $this->TravelAgentType : null;
    }
    /**
     * Set TravelAgentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelAgentType
     * @return \StructType\ViewAgent
     */
    public function setTravelAgentType($travelAgentType = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgentType) && !is_string($travelAgentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgentType, true), gettype($travelAgentType)), __LINE__);
        }
        if (is_null($travelAgentType) || (is_array($travelAgentType) && empty($travelAgentType))) {
            unset($this->TravelAgentType);
        } else {
            $this->TravelAgentType = $travelAgentType;
        }
        return $this;
    }
}
