<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveTravelAgencyPNRList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveTravelAgencyPNRList
 * @subpackage Structs
 */
class RetrieveTravelAgencyPNRList extends TransactionInfo
{
    /**
     * The RetrieveTravelAgencyPNRListRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveTravelAgencyPNRList
     */
    public $RetrieveTravelAgencyPNRListRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The BookingAgent
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingAgent;
    /**
     * The ExternalAppID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalAppID;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The FlightDate
     * @var string
     */
    public $FlightDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The PaxEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaxEmail;
    /**
     * The PaxPhone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaxPhone;
    /**
     * The ProfileID
     * @var int
     */
    public $ProfileID;
    /**
     * The TravelAgencyEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelAgencyEmail;
    /**
     * The TravelAgencyPhone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelAgencyPhone;
    /**
     * The IncludeActiveBookings
     * @var bool
     */
    public $IncludeActiveBookings;
    /**
     * The IncludePastBookings
     * @var bool
     */
    public $IncludePastBookings;
    /**
     * The IncludeCancelledBookings
     * @var bool
     */
    public $IncludeCancelledBookings;
    /**
     * The IncludeChildAgencyBookings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeChildAgencyBookings;
    /**
     * The BookedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookedDate;
    /**
     * Constructor method for RetrieveTravelAgencyPNRList
     * @uses RetrieveTravelAgencyPNRList::setRetrieveTravelAgencyPNRListRequest()
     * @uses RetrieveTravelAgencyPNRList::setActionType()
     * @uses RetrieveTravelAgencyPNRList::setIATANumber()
     * @uses RetrieveTravelAgencyPNRList::setBookingAgent()
     * @uses RetrieveTravelAgencyPNRList::setExternalAppID()
     * @uses RetrieveTravelAgencyPNRList::setConfirmationNumber()
     * @uses RetrieveTravelAgencyPNRList::setLastName()
     * @uses RetrieveTravelAgencyPNRList::setFirstName()
     * @uses RetrieveTravelAgencyPNRList::setFlightNumber()
     * @uses RetrieveTravelAgencyPNRList::setFlightDate()
     * @uses RetrieveTravelAgencyPNRList::setOrigin()
     * @uses RetrieveTravelAgencyPNRList::setDestination()
     * @uses RetrieveTravelAgencyPNRList::setPaxEmail()
     * @uses RetrieveTravelAgencyPNRList::setPaxPhone()
     * @uses RetrieveTravelAgencyPNRList::setProfileID()
     * @uses RetrieveTravelAgencyPNRList::setTravelAgencyEmail()
     * @uses RetrieveTravelAgencyPNRList::setTravelAgencyPhone()
     * @uses RetrieveTravelAgencyPNRList::setIncludeActiveBookings()
     * @uses RetrieveTravelAgencyPNRList::setIncludePastBookings()
     * @uses RetrieveTravelAgencyPNRList::setIncludeCancelledBookings()
     * @uses RetrieveTravelAgencyPNRList::setIncludeChildAgencyBookings()
     * @uses RetrieveTravelAgencyPNRList::setBookedDate()
     * @param \StructType\RetrieveTravelAgencyPNRList $retrieveTravelAgencyPNRListRequest
     * @param string $actionType
     * @param string $iATANumber
     * @param string $bookingAgent
     * @param string $externalAppID
     * @param string $confirmationNumber
     * @param string $lastName
     * @param string $firstName
     * @param string $flightNumber
     * @param string $flightDate
     * @param string $origin
     * @param string $destination
     * @param string $paxEmail
     * @param string $paxPhone
     * @param int $profileID
     * @param string $travelAgencyEmail
     * @param string $travelAgencyPhone
     * @param bool $includeActiveBookings
     * @param bool $includePastBookings
     * @param bool $includeCancelledBookings
     * @param bool $includeChildAgencyBookings
     * @param string $bookedDate
     */
    public function __construct(\StructType\RetrieveTravelAgencyPNRList $retrieveTravelAgencyPNRListRequest = null, $actionType = null, $iATANumber = null, $bookingAgent = null, $externalAppID = null, $confirmationNumber = null, $lastName = null, $firstName = null, $flightNumber = null, $flightDate = null, $origin = null, $destination = null, $paxEmail = null, $paxPhone = null, $profileID = null, $travelAgencyEmail = null, $travelAgencyPhone = null, $includeActiveBookings = null, $includePastBookings = null, $includeCancelledBookings = null, $includeChildAgencyBookings = null, $bookedDate = null)
    {
        $this
            ->setRetrieveTravelAgencyPNRListRequest($retrieveTravelAgencyPNRListRequest)
            ->setActionType($actionType)
            ->setIATANumber($iATANumber)
            ->setBookingAgent($bookingAgent)
            ->setExternalAppID($externalAppID)
            ->setConfirmationNumber($confirmationNumber)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setFlightNumber($flightNumber)
            ->setFlightDate($flightDate)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setPaxEmail($paxEmail)
            ->setPaxPhone($paxPhone)
            ->setProfileID($profileID)
            ->setTravelAgencyEmail($travelAgencyEmail)
            ->setTravelAgencyPhone($travelAgencyPhone)
            ->setIncludeActiveBookings($includeActiveBookings)
            ->setIncludePastBookings($includePastBookings)
            ->setIncludeCancelledBookings($includeCancelledBookings)
            ->setIncludeChildAgencyBookings($includeChildAgencyBookings)
            ->setBookedDate($bookedDate);
    }
    /**
     * Get RetrieveTravelAgencyPNRListRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveTravelAgencyPNRList|null
     */
    public function getRetrieveTravelAgencyPNRListRequest()
    {
        return isset($this->RetrieveTravelAgencyPNRListRequest) ? $this->RetrieveTravelAgencyPNRListRequest : null;
    }
    /**
     * Set RetrieveTravelAgencyPNRListRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveTravelAgencyPNRList $retrieveTravelAgencyPNRListRequest
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setRetrieveTravelAgencyPNRListRequest(\StructType\RetrieveTravelAgencyPNRList $retrieveTravelAgencyPNRListRequest = null)
    {
        if (is_null($retrieveTravelAgencyPNRListRequest) || (is_array($retrieveTravelAgencyPNRListRequest) && empty($retrieveTravelAgencyPNRListRequest))) {
            unset($this->RetrieveTravelAgencyPNRListRequest);
        } else {
            $this->RetrieveTravelAgencyPNRListRequest = $retrieveTravelAgencyPNRListRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\RetrieveTravelAgencyPNRList_ActionTypes::valueIsValid()
     * @uses \EnumType\RetrieveTravelAgencyPNRList_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveTravelAgencyPNRList_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveTravelAgencyPNRList_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\RetrieveTravelAgencyPNRList_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get BookingAgent value
     * @return string|null
     */
    public function getBookingAgent()
    {
        return $this->BookingAgent;
    }
    /**
     * Set BookingAgent value
     * @param string $bookingAgent
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setBookingAgent($bookingAgent = null)
    {
        // validation for constraint: string
        if (!is_null($bookingAgent) && !is_string($bookingAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingAgent, true), gettype($bookingAgent)), __LINE__);
        }
        $this->BookingAgent = $bookingAgent;
        return $this;
    }
    /**
     * Get ExternalAppID value
     * @return string|null
     */
    public function getExternalAppID()
    {
        return $this->ExternalAppID;
    }
    /**
     * Set ExternalAppID value
     * @param string $externalAppID
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setExternalAppID($externalAppID = null)
    {
        // validation for constraint: string
        if (!is_null($externalAppID) && !is_string($externalAppID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAppID, true), gettype($externalAppID)), __LINE__);
        }
        $this->ExternalAppID = $externalAppID;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get FlightDate value
     * @return string|null
     */
    public function getFlightDate()
    {
        return $this->FlightDate;
    }
    /**
     * Set FlightDate value
     * @param string $flightDate
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setFlightDate($flightDate = null)
    {
        // validation for constraint: string
        if (!is_null($flightDate) && !is_string($flightDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightDate, true), gettype($flightDate)), __LINE__);
        }
        $this->FlightDate = $flightDate;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get PaxEmail value
     * @return string|null
     */
    public function getPaxEmail()
    {
        return $this->PaxEmail;
    }
    /**
     * Set PaxEmail value
     * @param string $paxEmail
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setPaxEmail($paxEmail = null)
    {
        // validation for constraint: string
        if (!is_null($paxEmail) && !is_string($paxEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxEmail, true), gettype($paxEmail)), __LINE__);
        }
        $this->PaxEmail = $paxEmail;
        return $this;
    }
    /**
     * Get PaxPhone value
     * @return string|null
     */
    public function getPaxPhone()
    {
        return $this->PaxPhone;
    }
    /**
     * Set PaxPhone value
     * @param string $paxPhone
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setPaxPhone($paxPhone = null)
    {
        // validation for constraint: string
        if (!is_null($paxPhone) && !is_string($paxPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxPhone, true), gettype($paxPhone)), __LINE__);
        }
        $this->PaxPhone = $paxPhone;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get TravelAgencyEmail value
     * @return string|null
     */
    public function getTravelAgencyEmail()
    {
        return $this->TravelAgencyEmail;
    }
    /**
     * Set TravelAgencyEmail value
     * @param string $travelAgencyEmail
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setTravelAgencyEmail($travelAgencyEmail = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgencyEmail) && !is_string($travelAgencyEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgencyEmail, true), gettype($travelAgencyEmail)), __LINE__);
        }
        $this->TravelAgencyEmail = $travelAgencyEmail;
        return $this;
    }
    /**
     * Get TravelAgencyPhone value
     * @return string|null
     */
    public function getTravelAgencyPhone()
    {
        return $this->TravelAgencyPhone;
    }
    /**
     * Set TravelAgencyPhone value
     * @param string $travelAgencyPhone
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setTravelAgencyPhone($travelAgencyPhone = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgencyPhone) && !is_string($travelAgencyPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgencyPhone, true), gettype($travelAgencyPhone)), __LINE__);
        }
        $this->TravelAgencyPhone = $travelAgencyPhone;
        return $this;
    }
    /**
     * Get IncludeActiveBookings value
     * @return bool|null
     */
    public function getIncludeActiveBookings()
    {
        return $this->IncludeActiveBookings;
    }
    /**
     * Set IncludeActiveBookings value
     * @param bool $includeActiveBookings
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setIncludeActiveBookings($includeActiveBookings = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeActiveBookings) && !is_bool($includeActiveBookings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeActiveBookings, true), gettype($includeActiveBookings)), __LINE__);
        }
        $this->IncludeActiveBookings = $includeActiveBookings;
        return $this;
    }
    /**
     * Get IncludePastBookings value
     * @return bool|null
     */
    public function getIncludePastBookings()
    {
        return $this->IncludePastBookings;
    }
    /**
     * Set IncludePastBookings value
     * @param bool $includePastBookings
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setIncludePastBookings($includePastBookings = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePastBookings) && !is_bool($includePastBookings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePastBookings, true), gettype($includePastBookings)), __LINE__);
        }
        $this->IncludePastBookings = $includePastBookings;
        return $this;
    }
    /**
     * Get IncludeCancelledBookings value
     * @return bool|null
     */
    public function getIncludeCancelledBookings()
    {
        return $this->IncludeCancelledBookings;
    }
    /**
     * Set IncludeCancelledBookings value
     * @param bool $includeCancelledBookings
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setIncludeCancelledBookings($includeCancelledBookings = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCancelledBookings) && !is_bool($includeCancelledBookings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCancelledBookings, true), gettype($includeCancelledBookings)), __LINE__);
        }
        $this->IncludeCancelledBookings = $includeCancelledBookings;
        return $this;
    }
    /**
     * Get IncludeChildAgencyBookings value
     * @return bool|null
     */
    public function getIncludeChildAgencyBookings()
    {
        return $this->IncludeChildAgencyBookings;
    }
    /**
     * Set IncludeChildAgencyBookings value
     * @param bool $includeChildAgencyBookings
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setIncludeChildAgencyBookings($includeChildAgencyBookings = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildAgencyBookings) && !is_bool($includeChildAgencyBookings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildAgencyBookings, true), gettype($includeChildAgencyBookings)), __LINE__);
        }
        $this->IncludeChildAgencyBookings = $includeChildAgencyBookings;
        return $this;
    }
    /**
     * Get BookedDate value
     * @return string|null
     */
    public function getBookedDate()
    {
        return $this->BookedDate;
    }
    /**
     * Set BookedDate value
     * @param string $bookedDate
     * @return \StructType\RetrieveTravelAgencyPNRList
     */
    public function setBookedDate($bookedDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookedDate) && !is_string($bookedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookedDate, true), gettype($bookedDate)), __LINE__);
        }
        $this->BookedDate = $bookedDate;
        return $this;
    }
}
