<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAvailableCredit StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAvailableCredit
 * @subpackage Structs
 */
class RetrieveAvailableCredit extends TransactionInfo
{
    /**
     * The RetrieveAvailableCreditRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAvailableCredit
     */
    public $RetrieveAvailableCreditRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * Constructor method for RetrieveAvailableCredit
     * @uses RetrieveAvailableCredit::setRetrieveAvailableCreditRequest()
     * @uses RetrieveAvailableCredit::setIATANumber()
     * @param \StructType\RetrieveAvailableCredit $retrieveAvailableCreditRequest
     * @param string $iATANumber
     */
    public function __construct(\StructType\RetrieveAvailableCredit $retrieveAvailableCreditRequest = null, $iATANumber = null)
    {
        $this
            ->setRetrieveAvailableCreditRequest($retrieveAvailableCreditRequest)
            ->setIATANumber($iATANumber);
    }
    /**
     * Get RetrieveAvailableCreditRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAvailableCredit|null
     */
    public function getRetrieveAvailableCreditRequest()
    {
        return isset($this->RetrieveAvailableCreditRequest) ? $this->RetrieveAvailableCreditRequest : null;
    }
    /**
     * Set RetrieveAvailableCreditRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAvailableCredit $retrieveAvailableCreditRequest
     * @return \StructType\RetrieveAvailableCredit
     */
    public function setRetrieveAvailableCreditRequest(\StructType\RetrieveAvailableCredit $retrieveAvailableCreditRequest = null)
    {
        if (is_null($retrieveAvailableCreditRequest) || (is_array($retrieveAvailableCreditRequest) && empty($retrieveAvailableCreditRequest))) {
            unset($this->RetrieveAvailableCreditRequest);
        } else {
            $this->RetrieveAvailableCreditRequest = $retrieveAvailableCreditRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\RetrieveAvailableCredit
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
}
