<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgentDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgentDetails
 * @subpackage Structs
 */
class RetrieveAgentDetails extends TransactionInfo
{
    /**
     * The RetrieveAgentDetailsRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgentDetails
     */
    public $RetrieveAgentDetailsRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for RetrieveAgentDetails
     * @uses RetrieveAgentDetails::setRetrieveAgentDetailsRequest()
     * @uses RetrieveAgentDetails::setIATANumber()
     * @uses RetrieveAgentDetails::setUserId()
     * @param \StructType\RetrieveAgentDetails $retrieveAgentDetailsRequest
     * @param string $iATANumber
     * @param string $userId
     */
    public function __construct(\StructType\RetrieveAgentDetails $retrieveAgentDetailsRequest = null, $iATANumber = null, $userId = null)
    {
        $this
            ->setRetrieveAgentDetailsRequest($retrieveAgentDetailsRequest)
            ->setIATANumber($iATANumber)
            ->setUserId($userId);
    }
    /**
     * Get RetrieveAgentDetailsRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgentDetails|null
     */
    public function getRetrieveAgentDetailsRequest()
    {
        return isset($this->RetrieveAgentDetailsRequest) ? $this->RetrieveAgentDetailsRequest : null;
    }
    /**
     * Set RetrieveAgentDetailsRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgentDetails $retrieveAgentDetailsRequest
     * @return \StructType\RetrieveAgentDetails
     */
    public function setRetrieveAgentDetailsRequest(\StructType\RetrieveAgentDetails $retrieveAgentDetailsRequest = null)
    {
        if (is_null($retrieveAgentDetailsRequest) || (is_array($retrieveAgentDetailsRequest) && empty($retrieveAgentDetailsRequest))) {
            unset($this->RetrieveAgentDetailsRequest);
        } else {
            $this->RetrieveAgentDetailsRequest = $retrieveAgentDetailsRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\RetrieveAgentDetails
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \StructType\RetrieveAgentDetails
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
