<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginTravelAgentSingleSignOn StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginTravelAgentSingleSignOn
 * @subpackage Structs
 */
class LoginTravelAgentSingleSignOn extends TransactionInfo
{
    /**
     * The LoginTravelAgentRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LoginTravelAgentSingleSignOn
     */
    public $LoginTravelAgentRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * Constructor method for LoginTravelAgentSingleSignOn
     * @uses LoginTravelAgentSingleSignOn::setLoginTravelAgentRequest()
     * @uses LoginTravelAgentSingleSignOn::setIATANumber()
     * @uses LoginTravelAgentSingleSignOn::setUserName()
     * @uses LoginTravelAgentSingleSignOn::setEmail()
     * @param \StructType\LoginTravelAgentSingleSignOn $loginTravelAgentRequest
     * @param string $iATANumber
     * @param string $userName
     * @param string $email
     */
    public function __construct(\StructType\LoginTravelAgentSingleSignOn $loginTravelAgentRequest = null, $iATANumber = null, $userName = null, $email = null)
    {
        $this
            ->setLoginTravelAgentRequest($loginTravelAgentRequest)
            ->setIATANumber($iATANumber)
            ->setUserName($userName)
            ->setEmail($email);
    }
    /**
     * Get LoginTravelAgentRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LoginTravelAgentSingleSignOn|null
     */
    public function getLoginTravelAgentRequest()
    {
        return isset($this->LoginTravelAgentRequest) ? $this->LoginTravelAgentRequest : null;
    }
    /**
     * Set LoginTravelAgentRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LoginTravelAgentSingleSignOn $loginTravelAgentRequest
     * @return \StructType\LoginTravelAgentSingleSignOn
     */
    public function setLoginTravelAgentRequest(\StructType\LoginTravelAgentSingleSignOn $loginTravelAgentRequest = null)
    {
        if (is_null($loginTravelAgentRequest) || (is_array($loginTravelAgentRequest) && empty($loginTravelAgentRequest))) {
            unset($this->LoginTravelAgentRequest);
        } else {
            $this->LoginTravelAgentRequest = $loginTravelAgentRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\LoginTravelAgentSingleSignOn
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\LoginTravelAgentSingleSignOn
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\LoginTravelAgentSingleSignOn
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
}
