<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Associate ServiceType
 * @subpackage Services
 */
class Associate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AssociateToReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AssociateToReservation $parameters
     * @return \StructType\AssociateToReservationResponse|bool
     */
    public function AssociateToReservation(\StructType\AssociateToReservation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AssociateToReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AssociateToReservationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
